/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Named;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.ResourceLoadedListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class Resource
implements Serializable,
Named,
Cloneable {
    public static final long serialVersionUID = 1L;
    protected String name;
    final boolean named;
    private boolean locked;
    private boolean subResource;
    private final CreationDeserialization creationDeserialization = new CreationDeserialization(this);
    transient boolean created;
    transient boolean creating;
    transient boolean destroying;

    public Resource() {
        this.named = false;
    }

    public Resource(String name) {
        this.name = name;
        this.named = true;
    }

    public final void create() {
        if (!this.created && !this.creating) {
            this.creating = true;
            if (Resources.getCreatingCallback() != null) {
                Resources.getCreatingCallback().onCreating(this);
            }
            this.doCreate();
            this.creating = false;
            this.created = true;
        }
    }

    public final void destroy() {
        if (this.created && !this.destroying) {
            this.destroying = true;
            this.doDestroy();
            this.destroying = false;
            this.created = false;
        }
    }

    protected void doCreate() {
    }

    protected void doDestroy() {
    }

    public final synchronized boolean isCreated() {
        return this.created;
    }

    public String toString() {
        if (this.name == null) {
            return "a " + this.getClass().getName();
        }
        return this.name;
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Resource)) {
            return false;
        }
        Resource r = (Resource)obj;
        if (obj == this) {
            return true;
        }
        if (r.name == null || this.name == null) {
            return false;
        }
        return r.name.equals(this.name);
    }

    public final String getName() {
        return this.name;
    }

    public void load(Element element, Loader loader) throws Exception {
    }

    public Element save(Resource parent) {
        return null;
    }

    public void register() {
    }

    public void deregister() {
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public final void setLocked(boolean locked) {
        this.locked = locked;
    }

    public final boolean isSubResource() {
        return this.subResource;
    }

    public final void setSubResource(boolean subResource) {
        this.subResource = subResource;
    }

    public final Object writeReplace() throws ObjectStreamException {
        if (Resources.isRunMode()) {
            if (this.name == null) {
                return this;
            }
            return new SerializedResource(this);
        }
        return this;
    }

    public void setName(String name) {
        Resource oldResource = Resources.forget(this);
        this.name = name;
        if (oldResource != null) {
            if (name == null) {
                Resources.add(this);
            } else {
                Resources.put(this);
            }
        }
    }

    public final void toXML(XMLResourceWriter writer) throws IOException {
        String tag = Resources.getTag(this.getClass());
        if (tag == null) {
            writer.writeTag("instance");
            writer.writeAttribute("class", this.getClass().getName());
        } else {
            writer.writeTag(tag);
        }
        if (this.named) {
            writer.writeAttribute("name", this.name);
        }
        this.doToXML(writer);
        writer.closeTag();
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
    }

    public void archive() {
    }

    private static class CreationDeserialization
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Resource res;
        private boolean created;

        CreationDeserialization(Resource res) {
            this.res = res;
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if (this.created) {
                    Resources.queue(this.res);
                }
                return this;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new InvalidObjectException("Failed to deserialize resource " + this.res + " due to " + e);
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.created = this.res.isCreated();
            stream.defaultWriteObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Loader {
        public Resource load(Element var1) throws Exception;

        public void include(InputStream var1) throws Exception;

        public void pushMap(Map<String, Class<? extends Resource>> var1);

        public Map<String, Class<? extends Resource>> popMap();

        public void setLoadedListener(ResourceLoadedListener var1);

        public ResourceLoadedListener getLoadedListener();

        public void setOverwrite(boolean var1);

        public boolean isOverwrite();
    }

    private static final class SerializedResource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String resourceName;
        private transient Resource resource;

        public SerializedResource(Resource resourceToSerialize) {
            this.resourceName = resourceToSerialize.getName();
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof SerializedResource)) {
                return false;
            }
            SerializedResource r = (SerializedResource)obj;
            if (obj == this) {
                return true;
            }
            if (r.resource != null && this.resource != null) {
                return r.resource.equals(this.resource);
            }
            if (r.resourceName != null && this.resourceName != null) {
                return r.resourceName.equals(this.resourceName);
            }
            return false;
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return Resources.get(this.resourceName);
            }
            catch (Exception e) {
                throw new InvalidObjectException("Failed to deserialize resource " + this.resourceName + " due to " + e);
            }
        }
    }
}

