/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Resource;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class Memory
extends Resource {
    public static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private static final Map<String, AllocationHandler> allocatorMap = new HashMap<String, AllocationHandler>();
    private String allocatorName;
    private int length;
    private AllocationHandler.Entry entry;
    private ByteBuffer buffer;

    public Memory(String allocatorName, int length) {
        super("Memory allocation (" + length + " bytes)");
        this.allocatorName = allocatorName;
        this.length = length;
    }

    public static synchronized void init(String name, ByteBuffer allocator) {
        AllocationHandler ah = new AllocationHandler(allocator);
        allocatorMap.put(name, ah);
    }

    protected final synchronized void doCreate() {
        AllocationHandler handler = allocatorMap.get(this.allocatorName);
        this.length = Math.max(32, this.length);
        this.entry = handler.allocate(this.length);
        if (this.entry == null) {
            throw new RuntimeException("Couldn't allocate " + this.length + " bytes from " + this.allocatorName);
        }
        this.buffer = this.entry.createBuffer();
    }

    protected void doDestroy() {
        this.entry.merge();
        this.entry = null;
        this.buffer = null;
    }

    public final ByteBuffer getBuffer() {
        assert (this.isCreated());
        return this.buffer;
    }

    public static synchronized void cleanup(String name) {
        allocatorMap.remove(name);
    }

    public static ByteBuffer chop(ByteBuffer src, int byteOffset, int length) {
        ByteBuffer ret = src.duplicate();
        ret.clear().position(byteOffset).limit(byteOffset + length);
        ret = ret.slice();
        ret.order(ByteOrder.nativeOrder());
        return ret;
    }

    public static ByteBuffer chop(ByteBuffer src, int byteOffset) {
        ByteBuffer ret = src.duplicate();
        ret.clear().position(byteOffset);
        ret = ret.slice();
        ret.order(ByteOrder.nativeOrder());
        return ret;
    }

    private static class AllocationHandler {
        final ByteBuffer allocator;
        final Entry entry;

        AllocationHandler(ByteBuffer allocator) {
            this.allocator = allocator;
            this.entry = new Entry();
            this.entry.length = allocator.capacity();
        }

        Entry allocate(int size) {
            Entry e = this.entry;
            while (e != null) {
                if (e.allocated || e.length < size) {
                    e = e.next;
                    continue;
                }
                e.split(size);
                return e;
            }
            return null;
        }

        class Entry {
            int position;
            int length;
            boolean allocated;
            Entry next;
            Entry prev;

            Entry() {
            }

            void merge() {
                assert (this.allocated);
                this.allocated = false;
                Entry current = this;
                while (current.prev != null && !current.prev.allocated) {
                    current = current.prev;
                }
                while (current.next != null && !current.next.allocated) {
                    current.length += current.next.length;
                    current.next = current.next.next;
                }
                if (current.next != null) {
                    current.next.prev = current;
                }
            }

            void split(int size) {
                assert (!this.allocated);
                assert (size <= this.length);
                this.allocated = true;
                if (size == this.length) {
                    return;
                }
                Entry newEntry = new Entry();
                newEntry.prev = this;
                newEntry.next = this.next;
                newEntry.position = this.position + size;
                newEntry.length = this.length - size;
                this.length = size;
                this.next = newEntry;
            }

            ByteBuffer createBuffer() {
                ByteBuffer dup = AllocationHandler.this.allocator.duplicate();
                dup.clear().limit(this.position + this.length);
                dup.position(this.position);
                return dup.slice().order(ByteOrder.nativeOrder());
            }
        }
    }
}

