/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.WritableDimension;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public final class Glyph
implements Serializable,
ReadableRectangle {
    static final long serialVersionUID = 1L;
    private int advance;
    private int height;
    private int width;
    private int x;
    private int y;
    private int bearingX;
    private int bearingY;
    private ArrayList<Glyph> kernsWith;
    private int[] kerning;

    public void init(int x, int y, int width, int height, int bearingX, int bearingY, int advance, Glyph[] kernsWith, int[] kerning) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bearingX = bearingX;
        this.bearingY = bearingY;
        this.advance = advance;
        this.kernsWith = kernsWith != null ? new ArrayList<Glyph>(Arrays.asList(kernsWith)) : null;
        this.kerning = kerning;
    }

    public int getKerningAfter(Glyph g) {
        if (g == null) {
            return 0;
        }
        if (this.kernsWith == null) {
            return 0;
        }
        int i = 0;
        while (i < this.kernsWith.size()) {
            Glyph g2 = this.kernsWith.get(i);
            if (g2 == g) {
                return this.kerning[i];
            }
            ++i;
        }
        return 0;
    }

    public void getBounds(WritableRectangle dest) {
        dest.setBounds(this.x, this.y, this.width, this.height);
    }

    public void getBearing(WritablePoint dest) {
        dest.setLocation(this.bearingX, this.bearingY);
    }

    public int getAdvance() {
        return this.advance;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getBearingX() {
        return this.bearingX;
    }

    public int getBearingY() {
        return this.bearingY;
    }

    public void getSize(WritableDimension dest) {
        dest.setSize(this.width, this.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void getLocation(WritablePoint dest) {
        dest.setLocation(this.x, this.y);
    }
}

