/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.utils;

public class MemUtils {
    private static final char[] bytes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final int cmp(byte[] mem1, byte[] mem2, int len) {
        int i = 0;
        while (i < len) {
            if (mem1[i] != mem2[i]) {
                if (mem1[i] < mem2[i]) {
                    return -i;
                }
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static final void set(byte[] mem, int offset, int val, int len) {
        len += offset;
        int i = offset;
        while (i < len) {
            mem[i] = (byte)val;
            ++i;
        }
    }

    public static final void set(short[] mem, int offset, int val, int len) {
        len += offset;
        int i = offset;
        while (i < len) {
            mem[i] = (short)val;
            ++i;
        }
    }

    public static final void set(int[] mem, int offset, int val, int len) {
        len += offset;
        int i = offset;
        while (i < len) {
            mem[i] = val;
            ++i;
        }
    }

    public static final void set(Object[] mem, int offset, Object val, int len) {
        len += offset;
        int i = offset;
        while (i < len) {
            mem[i] = val;
            ++i;
        }
    }

    public static final boolean startsWith(byte[] arr, int offset, int len, byte[] pattern) {
        int length = pattern.length;
        if (len < length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (arr[offset + i] != pattern[i]) break;
            ++i;
        }
        return i == length;
    }

    public static final void dump(byte[] mem, int start, int len) {
        StringBuilder string = new StringBuilder(50);
        StringBuilder chars = new StringBuilder(18);
        String vis = new String(mem, start, len);
        int j = 0;
        int i = 0;
        while (i < len) {
            int b = mem[i + start];
            if (b < 0) {
                b += 256;
            }
            if (b > 32 && b < 127) {
                chars.append(vis.charAt(i));
            } else {
                chars.append(".");
            }
            string.append(bytes[b / 16]);
            string.append(bytes[b % 16]);
            string.append(" ");
            if (++j != 16 && ++i != len) continue;
            System.out.println(i - j + "  " + string.toString() + chars.toString());
            string.setLength(0);
            chars.setLength(0);
            j = 0;
        }
    }
}

