/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.utils;

public class Debug {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static int level = 3;
    private static int counter = 0;
    private static long startTime = 0L;
    public static final String[] prefix = new String[]{"NONE", "ERRO", "WARN", "INFO", "DBUG"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int genId() {
        Class<Debug> clazz = Debug.class;
        synchronized (Debug.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return counter++;
        }
    }

    public static String rpad(String s, int length) {
        if (length > s.length()) {
            int sz = length - s.length();
            char[] arr = new char[sz];
            int n = 0;
            while (n < sz) {
                arr[n] = 32;
                ++n;
            }
            return String.valueOf(s) + new String(arr);
        }
        return s;
    }

    public static void log(int lev, String line) {
        long t = System.currentTimeMillis();
        if (startTime == 0L) {
            startTime = t;
        }
        t -= startTime;
        if (lev <= level) {
            if (level >= 4) {
                System.out.println("[" + Debug.rpad(Thread.currentThread().getName(), 30) + " " + Debug.rpad(Long.toString(t), 6) + " " + prefix[lev] + "] " + line);
            } else {
                System.out.println("[" + prefix[lev] + "] " + line);
            }
        }
    }

    public static void error(String line) {
        Debug.log(1, line);
    }

    public static void warning(String line) {
        Debug.log(2, line);
    }

    public static void warn(String line) {
        Debug.log(2, line);
    }

    public static void info(String line) {
        Debug.log(3, line);
    }

    public static void debug(String line) {
        Debug.log(4, line);
    }
}

