/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Clock;
import com.fluendo.jst.WaitStatus;
import com.fluendo.utils.Debug;

public class SystemClock
extends Clock {
    protected long getInternalTime() {
        return System.currentTimeMillis() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaitStatus waitFunc(Clock.ClockID id) {
        WaitStatus res = new WaitStatus();
        long real = this.getInternalTime();
        long entryt = id.time;
        long now = this.adjust(real);
        res.jitter = now - entryt;
        if (res.jitter < 0L) {
            Debug.log(4, "Waiting from " + now + " until " + entryt + " (" + -res.jitter + "us)");
            long millis = -res.jitter / 1000L;
            int nanos = (int)(-res.jitter % 1000L * 1000L);
            SystemClock systemClock = this;
            synchronized (systemClock) {
                if (id.status == 2) {
                    res.status = 2;
                    return res;
                }
                id.status = 0;
                try {
                    this.wait(millis, nanos);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            res.status = id.status;
        } else if (res.jitter == 0L) {
            res.status = 0;
        } else {
            Debug.log(4, "Wait for timestamp " + now + " is late by " + res.jitter + "us");
            res.status = 1;
        }
        return res;
    }

    protected WaitStatus waitAsyncFunc(Clock.ClockID id) {
        return WaitStatus.newOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unscheduleFunc(Clock.ClockID id) {
        SystemClock systemClock = this;
        synchronized (systemClock) {
            id.status = 2;
            this.notifyAll();
        }
    }
}

