/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.BlockMapping;
import com.fluendo.jheora.CodingMode;
import com.fluendo.jheora.Coordinate;
import com.fluendo.jheora.Filter;
import com.fluendo.jheora.FrArray;
import com.fluendo.jheora.FrInit;
import com.fluendo.jheora.HuffEntry;
import com.fluendo.jheora.HuffTables;
import com.fluendo.jheora.Huffman;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.MotionVector;
import com.jcraft.jogg.Buffer;

public class Playback {
    private static final int DCT_KEY_FRAME = 0;
    Buffer opb = new Buffer();
    Info info;
    int keyframe_granule_shift;
    int DecoderErrorCode;
    int FramesHaveBeenSkipped;
    int PostProcessEnabled;
    int PostProcessingLevel;
    byte FrameType;
    byte KeyFrameType;
    int QualitySetting;
    int FrameQIndex;
    int CodedBlockIndex;
    int CodedBlocksThisFrame;
    int FrameSize;
    int[] frameQIS = new int[3];
    int frameNQIS;
    int YPlaneSize;
    int UVPlaneSize;
    int YStride;
    int UVStride;
    int VFragments;
    int HFragments;
    int UnitFragments;
    int YPlaneFragments;
    int UVPlaneFragments;
    int ReconYPlaneSize;
    int ReconUVPlaneSize;
    int YDataOffset;
    int UDataOffset;
    int VDataOffset;
    int ReconYDataOffset;
    int ReconUDataOffset;
    int ReconVDataOffset;
    int YSuperBlocks;
    int UVSuperBlocks;
    int SuperBlocks;
    int YSBRows;
    int YSBCols;
    int UVSBRows;
    int UVSBCols;
    int YMacroBlocks;
    int UVMacroBlocks;
    int MacroBlocks;
    short[] ThisFrameRecon;
    short[] GoldenFrame;
    short[] LastFrameRecon;
    short[] PostProcessBuffer;
    int[] pixel_index_table;
    int[] recon_pixel_index_table;
    byte[] display_fragments;
    int[] CodedBlockList;
    MotionVector[] FragMVect;
    int[] FragTokenCounts;
    int[] FragQIndex;
    byte[] FragCoefEOB;
    short[][] QFragData;
    byte[] FragQs;
    CodingMode[] FragCodingMethod;
    BlockMapping BlockMap;
    byte[] SBCodedFlags;
    byte[] SBFullyFlags;
    byte[] MBCodedFlags;
    byte[] MBFullyFlags;
    Coordinate[] FragCoordinates;
    FrArray frArray = new FrArray();
    Filter filter = new Filter();
    byte[] blockQ;
    int[] quant_index = new int[64];
    HuffEntry[] HuffRoot_VP3x = new HuffEntry[80];
    int[][] HuffCodeArray_VP3x;
    byte[][] HuffCodeLengthArray_VP3x;
    byte[] ExtraBitLengths_VP3x;

    public void clear() {
        if (this.opb != null) {
            this.opb = null;
        }
    }

    private static int ilog(long v) {
        int ret = 0;
        while (v != 0L) {
            ++ret;
            v >>= 1;
        }
        return ret;
    }

    public Playback(Info ci) {
        this.info = ci;
        this.DecoderErrorCode = 0;
        this.KeyFrameType = 0;
        this.FramesHaveBeenSkipped = 0;
        FrInit.InitFrameDetails(this);
        this.keyframe_granule_shift = Playback.ilog(ci.keyframe_frequency_force - 1L);
        this.filter.copyFilterTables(ci);
        this.initHuffmanTrees(ci);
    }

    public int getFrameType() {
        return this.FrameType;
    }

    void setFrameType(byte FrType) {
        switch (FrType) {
            case 0: {
                this.FrameType = FrType;
                break;
            }
            default: {
                this.FrameType = FrType;
            }
        }
    }

    public void clearHuffmanSet() {
        Huffman.clearHuffmanTrees(this.HuffRoot_VP3x);
        this.HuffCodeArray_VP3x = null;
        this.HuffCodeLengthArray_VP3x = null;
    }

    public void initHuffmanSet() {
        this.clearHuffmanSet();
        this.ExtraBitLengths_VP3x = HuffTables.ExtraBitLengths_VP31;
        this.HuffCodeArray_VP3x = new int[80][32];
        this.HuffCodeLengthArray_VP3x = new byte[80][32];
        int i = 0;
        while (i < 80) {
            Huffman.buildHuffmanTree(this.HuffRoot_VP3x, this.HuffCodeArray_VP3x[i], this.HuffCodeLengthArray_VP3x[i], i, HuffTables.FrequencyCounts_VP3[i]);
            ++i;
        }
    }

    public int readHuffmanTrees(Info ci, Buffer opb) {
        int i = 0;
        while (i < 80) {
            ci.HuffRoot[i] = new HuffEntry();
            int ret = ci.HuffRoot[i].read(0, opb);
            if (ret != 0) {
                return ret;
            }
            ++i;
        }
        return 0;
    }

    public void initHuffmanTrees(Info ci) {
        this.ExtraBitLengths_VP3x = HuffTables.ExtraBitLengths_VP31;
        int i = 0;
        while (i < 80) {
            this.HuffRoot_VP3x[i] = ci.HuffRoot[i].copy();
            ++i;
        }
    }
}

