/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.eval;

import java.math.BigDecimal;
import java.math.MathContext;
import net.java.dev.eval.Type;

abstract class Operator {
    static final Operator END = new Operator(-1, 0, null, null, null){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            throw new RuntimeException("END is a dummy operation");
        }
    };
    static final Operator TERNARY = new Operator(0, 3, "?", null, null){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.signum() != 0 ? value2 : value3;
        }
    };
    static final Operator AND = new Operator(0, 2, "&&", Type.BOOLEAN, Type.BOOLEAN){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.signum() != 0 && value2.signum() != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator OR = new Operator(0, 2, "||", Type.BOOLEAN, Type.BOOLEAN){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.signum() != 0 || value2.signum() != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator GT = new Operator(1, 2, ">", Type.BOOLEAN, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) > 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator GE = new Operator(1, 2, ">=", Type.BOOLEAN, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator LT = new Operator(1, 2, "<", Type.BOOLEAN, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) < 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator LE = new Operator(1, 2, "<=", Type.BOOLEAN, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) <= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator EQ = new Operator(1, 2, "==", Type.BOOLEAN, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator NE = new Operator(1, 2, "!=", Type.BOOLEAN, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    };
    static final Operator ADD = new Operator(2, 2, "+", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.add(value2);
        }
    };
    static final Operator SUB = new Operator(2, 2, "-", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.subtract(value2);
        }
    };
    static final Operator DIV = new Operator(3, 2, "/", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.divide(value2, MathContext.DECIMAL128);
        }
    };
    static final Operator REMAINDER = new Operator(3, 2, "%", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.remainder(value2, MathContext.DECIMAL128);
        }
    };
    static final Operator MUL = new Operator(3, 2, "*", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.multiply(value2);
        }
    };
    static final Operator NEG = new Operator(4, 1, "-", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.negate();
        }
    };
    static final Operator PLUS = new Operator(4, 1, "+", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1;
        }
    };
    static final Operator ABS = new Operator(4, 1, " abs ", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.abs();
        }
    };
    static final Operator POW = new Operator(4, 2, " pow ", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            try {
                return value1.pow(value2.intValueExact());
            }
            catch (ArithmeticException ae) {
                throw new RuntimeException("pow argument: " + ae.getMessage());
            }
        }
    };
    static final Operator INT = new Operator(4, 1, "int ", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return new BigDecimal(value1.toBigInteger());
        }
    };
    static final Operator NOP = new Operator(4, 1, "", Type.ARITHMETIC, Type.ARITHMETIC){

        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1;
        }
    };
    final int precedence;
    final int numberOfOperands;
    final String string;
    final Type resultType;
    final Type operandType;

    Operator(int precedence, int numberOfOperands, String string, Type resultType, Type operandType) {
        this.precedence = precedence;
        this.numberOfOperands = numberOfOperands;
        this.string = string;
        this.resultType = resultType;
        this.operandType = operandType;
    }

    abstract BigDecimal perform(BigDecimal var1, BigDecimal var2, BigDecimal var3);
}

