/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.sprites.DefaultSpriteRenderer;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteProcessor;
import com.shavenpuppy.jglib.sprites.SpriteRenderer;
import java.io.Serializable;

public class StaticSpriteEngine
extends Resource
implements SpriteEngine {
    private static final long serialVersionUID = 1L;
    private Sprite[] sprites;
    private int numAllocated;
    private int numVisible;
    private final DefaultSpriteRenderer renderer;
    private int tickRate;
    private float alpha = 1.0f;
    private SpriteProcessor spriteProcessor;
    static int totalAllocated;

    public static int getTotalAllocated() {
        return totalAllocated;
    }

    public StaticSpriteEngine(boolean sortY, int sortLayer, int maxSprites, boolean uniqueSprites, int tickRate) {
        if (tickRate < 1) {
            throw new IllegalArgumentException("tickRate must be > 0");
        }
        if (maxSprites < 1) {
            throw new IllegalArgumentException("maxSprites must be > 0");
        }
        this.sprites = new Sprite[maxSprites];
        this.tickRate = tickRate;
        int i = 0;
        while (i < maxSprites) {
            this.sprites[i] = new Sprite(this);
            this.sprites[i].index = i;
            ++i;
        }
        this.renderer = new DefaultSpriteRenderer(sortY, sortLayer, maxSprites, uniqueSprites);
        this.spriteProcessor = new SpriteProcessor(){

            public void processRendering(Sprite[] sprite, int start, int end, SpriteRenderer renderer) {
                int i = start;
                while (i < end) {
                    Sprite s = StaticSpriteEngine.this.sprites[i];
                    if (s.isVisible() && s.isActive()) {
                        renderer.render(s);
                        StaticSpriteEngine staticSpriteEngine = StaticSpriteEngine.this;
                        staticSpriteEngine.numVisible = staticSpriteEngine.numVisible + 1;
                    }
                    ++i;
                }
            }
        };
    }

    public SpriteProcessor getSpriteProcessor() {
        return this.spriteProcessor;
    }

    public void setSpriteProcessor(SpriteProcessor spriteProcessor) {
        this.spriteProcessor = spriteProcessor;
    }

    protected void doCreate() {
        this.renderer.create();
    }

    protected void doDestroy() {
        this.renderer.destroy();
    }

    public void setTickRate(int newTickRate) {
        this.tickRate = newTickRate;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public Sprite allocate(Serializable owner) {
        if (this.numAllocated == this.sprites.length) {
            throw new IndexOutOfBoundsException("No sprites left: all " + this.numAllocated + " allocated");
        }
        if (owner == null) {
            throw new NullPointerException("No owner specified");
        }
        ++totalAllocated;
        Sprite s = this.sprites[this.numAllocated++];
        s.init(owner);
        return s;
    }

    public int maxSprites() {
        return this.sprites.length;
    }

    public int numAllocated() {
        return this.numAllocated;
    }

    public int numFree() {
        return this.sprites.length - this.numAllocated;
    }

    public void deallocate(Sprite sprite) {
        --totalAllocated;
        this.sprites[sprite.index] = this.sprites[--this.numAllocated];
        this.sprites[sprite.index].index = sprite.index;
        this.sprites[this.numAllocated] = sprite;
        sprite.index = this.numAllocated;
    }

    public void clear() {
        int i = this.numAllocated;
        while (--i >= 0) {
            this.sprites[i].deallocate();
        }
    }

    public void tick() {
        int n = this.numAllocated;
        int i = 0;
        while (i < n) {
            Sprite s = this.sprites[i];
            if (s.isActive()) {
                s.tick();
            }
            ++i;
        }
    }

    public void render() {
        this.numVisible = 0;
        this.renderer.setAlpha(this.alpha);
        this.renderer.preRender();
        this.spriteProcessor.processRendering(this.sprites, 0, this.numAllocated, this.renderer);
        this.renderer.postRender();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public SpriteRenderer getSpriteRenderer() {
        return this.renderer;
    }
}

