/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.AttenuatorFeature;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.ReadablePosition;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.io.Serializable;
import org.w3c.dom.Element;

public class SoundCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private static SoundPlayer soundPlayer;
    private String player;
    private String sound;
    private String attenuator;
    private transient ALBuffer soundResource;
    private transient SoundPlayer playerFeature;
    private transient AttenuatorFeature attenuatorFeature;

    public static void setDefaultSoundPlayer(SoundPlayer soundPlayer) {
        SoundCommand.soundPlayer = soundPlayer;
    }

    public static SoundPlayer getDefaultSoundPlayer() {
        return soundPlayer;
    }

    public boolean execute(Animated target, int tickRate) {
        SoundEffect fx;
        SoundPlayer p;
        SoundPlayer soundPlayer = p = this.playerFeature == null ? SoundCommand.soundPlayer : this.playerFeature;
        if (this.soundResource != null && p != null && (fx = p.allocate(this.soundResource, (Object)target)) != null) {
            Serializable otarget;
            if (this.attenuatorFeature != null && (otarget = ((Sprite)target).getOwner()) instanceof ReadablePosition) {
                ReadablePosition ptarget = (ReadablePosition)((Object)otarget);
                float gain = this.attenuatorFeature.getVolume(ptarget.getX(), ptarget.getY());
                fx.setGain(gain, target);
            }
            fx.play(target);
        }
        target.setSequence(target.getSequence() + 1);
        return true;
    }

    protected void doCreate() {
        this.soundResource = (ALBuffer)Resources.get(this.sound);
        if (this.player != null) {
            this.playerFeature = (SoundPlayer)Resources.get(this.player);
        }
        if (this.attenuator != null) {
            this.attenuatorFeature = (AttenuatorFeature)Resources.get(this.attenuator);
        }
    }

    protected void doDestroy() {
        this.soundResource = null;
        this.playerFeature = null;
        this.attenuatorFeature = null;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.player != null) {
            writer.writeAttribute("player", this.player);
        }
        if (this.attenuator != null) {
            writer.writeAttribute("attenuator", this.attenuator);
        }
        writer.writeAttribute("sound", this.sound);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.player = XMLUtil.getString(element, "player", null);
        this.attenuator = XMLUtil.getString(element, "attenuator", null);
        this.sound = XMLUtil.getString(element, "sound");
    }
}

