/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RandomGotoCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private Object[] destinations;

    public boolean execute(Animated target, int tickRate) {
        Object s = this.destinations[Util.random(0, this.destinations.length - 1)];
        if (s instanceof String) {
            int d = target.getAnimation().getLabel((String)s);
            if (d != -1) {
                target.setSequence(d);
            } else {
                System.err.println("Animation " + target.getAnimation() + ": missing label " + s);
            }
        } else {
            target.setSequence((Integer)s);
        }
        return true;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        NodeList nl = element.getElementsByTagName("dest");
        LinkedList<Object> seqs = new LinkedList<Object>();
        int i = 0;
        while (i < nl.getLength()) {
            Object d;
            Element destElement = (Element)nl.item(i);
            if (XMLUtil.hasAttribute(destElement, "id")) {
                d = XMLUtil.getString(destElement, "id");
                seqs.add(d);
            } else {
                d = new Integer(XMLUtil.getInt(destElement, "seq"));
                seqs.add(d);
            }
            if (XMLUtil.hasAttribute(destElement, "n")) {
                int n = XMLUtil.getInt(destElement, "n");
                int j = 0;
                while (j < n) {
                    seqs.add(d);
                    ++j;
                }
            }
            ++i;
        }
        this.destinations = new Object[seqs.size()];
        seqs.toArray(this.destinations);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        int i = 0;
        while (i < this.destinations.length) {
            writer.writeTag("dest");
            if (this.destinations[i] instanceof String) {
                writer.writeAttribute("id", this.destinations[i], true);
            } else {
                writer.writeAttribute("seq", (Integer)this.destinations[i], true);
            }
            writer.closeTag();
            ++i;
        }
    }
}

