/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TextResource
extends Resource {
    public static final long serialVersionUID = 1L;
    private String text;

    public TextResource() {
    }

    public TextResource(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        NodeList children = element.getChildNodes();
        if (children.getLength() != 1) {
            throw new Exception("Text resource needs some text!");
        }
        Text node = (Text)children.item(0);
        this.text = this.format(node.getNodeValue().trim());
    }

    private String format(String raw) {
        StringBuffer ret = new StringBuffer(raw.length());
        boolean ignoreWhiteSpace = true;
        boolean addSpace = false;
        int i = 0;
        while (i < raw.length()) {
            char c = raw.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!ignoreWhiteSpace) {
                    ignoreWhiteSpace = true;
                    addSpace = true;
                }
            } else {
                ignoreWhiteSpace = false;
                if (addSpace) {
                    ret.append(' ');
                    addSpace = false;
                }
                ret.append(c);
            }
            ++i;
        }
        return ret.toString();
    }

    public final String getText() {
        return this.text;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeText(this.text);
    }
}

