/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.ImageWrapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Element;

public class ImageResource
extends Resource
implements ImageWrapper {
    public static final long serialVersionUID = 1L;
    private String url;
    private transient Image image;

    public ImageResource(String name) {
        super(name);
    }

    protected void doCreate() {
        try {
            BufferedInputStream bis = this.url.startsWith("classpath:") ? new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))) : new BufferedInputStream(new URL(this.url).openStream());
            this.image = Image.read(bis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doDestroy() {
        this.image = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.url = element.getAttribute("url");
    }

    public final Image getImage() throws Exception {
        if (!this.isCreated()) {
            this.create();
        }
        if (this.image.getData() == null) {
            this.doCreate();
        }
        return this.image;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("url", this.url);
    }
}

