/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.ColorParser;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.ReadableColorMap;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.w3c.dom.Element;

public class ColorMapFeature
extends Feature
implements ReadableColorMap {
    private static ColorMapFeature defaultColorMap;
    private SortedMap colorNameMap;
    private Map colorMap;
    private boolean hsb;
    private boolean default_;

    public ColorMapFeature() {
    }

    public ColorMapFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public static ColorMapFeature getDefaultColorMap() {
        return defaultColorMap;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List colors = XMLUtil.getChildren(element, "color");
        this.colorNameMap = new TreeMap();
        this.colorMap = new HashMap();
        int count = 0;
        Iterator i = colors.iterator();
        while (i.hasNext()) {
            Element color = (Element)i.next();
            String id = XMLUtil.getString(color, "id");
            int order = XMLUtil.getInt(color, "order", count++);
            Color c = ColorParser.parse(XMLUtil.getString(color, "c"));
            this.colorNameMap.put(new ColorName(id, order), c);
            this.colorMap.put(id, c);
        }
    }

    protected boolean shouldWriteAttribute(String attribute) {
        if (attribute.equals("autoCreated") || attribute.equals("colorMap") || attribute.equals("colorNameMap")) {
            return false;
        }
        return super.shouldWriteAttribute(attribute);
    }

    protected void doWriteChildren(XMLResourceWriter writer) throws IOException {
        boolean isCompact = writer.isCompact();
        writer.setCompact(true);
        Iterator i = this.colorNameMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ColorName cn = (ColorName)e.getKey();
            Color value = (Color)e.getValue();
            writer.writeTag("color");
            writer.writeAttribute("id", cn.name, true);
            writer.writeAttribute("order", cn.order);
            if (this.hsb) {
                float[] colorHSB = value.toHSB(null);
                writer.writeAttribute("c", "!" + (int)(255.0f * colorHSB[0]) + "," + (int)(255.0f * colorHSB[1]) + "," + (int)(255.0f * colorHSB[2]));
            } else {
                writer.writeAttribute("c", String.valueOf(value.getRed()) + "," + value.getGreen() + "," + value.getBlue() + "," + value.getAlpha());
            }
            writer.closeTag();
        }
        writer.setCompact(isCompact);
    }

    public ReadableColor getColor(String name) {
        return (ReadableColor)this.colorMap.get(name);
    }

    public void setColor(String name, ReadableColor newColor) {
        Color oldColor = (Color)this.colorMap.get(name);
        if (oldColor == null) {
            oldColor = new Color();
            this.colorMap.put(name, oldColor);
            this.colorNameMap.put(new ColorName(name, this.colorNameMap.size()), oldColor);
        }
        oldColor.setColor(newColor);
    }

    public SortedMap getColorNameMap() {
        return this.colorNameMap;
    }

    public void copy(ReadableColorMap source) {
        Set names = source.getNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.setColor(name, source.getColor(name));
        }
    }

    public Set getNames() {
        return this.colorMap.keySet();
    }

    protected void doRegister() {
        super.doRegister();
        if (this.default_) {
            defaultColorMap = this;
        }
    }

    protected void doDeregister() {
        super.doDeregister();
        if (this.default_) {
            defaultColorMap = null;
        }
    }

    public static class ColorName
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 1L;
        public final String name;
        public final int order;

        public ColorName(String name, int order) {
            this.name = name;
            this.order = order;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object arg0) {
            ColorName c = (ColorName)arg0;
            if (this.order < c.order) {
                return -1;
            }
            if (this.order > c.order) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColorName other = (ColorName)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

