/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.SimpleRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import java.io.Serializable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.Renderable;
import org.lwjgl.util.WritableDimension;
import org.w3c.dom.Element;

public class Background
extends Feature {
    private static final long serialVersionUID = 1L;
    private static GLBaseTexture current;
    private String top_left;
    private String top_right;
    private String bottom_left;
    private String bottom_right;
    private String top;
    private String left;
    private String bottom;
    private String right;
    private String middle;
    private MappedColor color;
    private MappedColor topColor;
    private MappedColor bottomColor;
    private MappedColor leftColor;
    private MappedColor rightColor;
    private MappedColor topLeftColor;
    private MappedColor bottomLeftColor;
    private MappedColor topRightColor;
    private MappedColor bottomRightColor;
    private Rectangle insets;
    private transient SpriteImage top_left_image;
    private transient SpriteImage top_right_image;
    private transient SpriteImage bottom_left_image;
    private transient SpriteImage bottom_right_image;
    private transient SpriteImage top_image;
    private transient SpriteImage left_image;
    private transient SpriteImage bottom_image;
    private transient SpriteImage right_image;
    private transient SpriteImage middle_image;

    public Background() {
        this.setAutoCreated();
    }

    public Background(String name) {
        super(name);
        this.setAutoCreated();
    }

    public Instance spawn() {
        return new Instance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        if (this.topColor == null) {
            this.topColor = this.color;
        }
        if (this.bottomColor == null) {
            this.bottomColor = this.color;
        }
        if (this.leftColor == null) {
            this.leftColor = this.color;
        }
        if (this.rightColor == null) {
            this.rightColor = this.color;
        }
        if (this.topLeftColor == null) {
            this.topLeftColor = this.topColor;
        }
        if (this.topLeftColor == null) {
            this.topLeftColor = this.leftColor;
        }
        if (this.topRightColor == null) {
            this.topRightColor = this.topColor;
        }
        if (this.topRightColor == null) {
            this.topRightColor = this.rightColor;
        }
        if (this.bottomLeftColor == null) {
            this.bottomLeftColor = this.bottomColor;
        }
        if (this.bottomLeftColor == null) {
            this.bottomLeftColor = this.leftColor;
        }
        if (this.bottomRightColor == null) {
            this.bottomRightColor = this.bottomColor;
        }
        if (this.bottomRightColor == null) {
            this.bottomRightColor = this.rightColor;
        }
        if (this.topLeftColor == null) {
            this.topLeftColor = new MappedColor(Color.WHITE);
        }
        if (this.bottomLeftColor == null) {
            this.bottomLeftColor = new MappedColor(Color.WHITE);
        }
        if (this.topRightColor == null) {
            this.topRightColor = new MappedColor(Color.WHITE);
        }
        if (this.bottomRightColor == null) {
            this.bottomRightColor = new MappedColor(Color.WHITE);
        }
        if (this.insets == null) {
            this.insets = new Rectangle();
        }
    }

    public class Instance
    implements SimpleRenderable,
    Renderable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ReadableRectangle bounds;
        private ReadableColor instanceColor = Color.WHITE;
        private final Color blendColor = new Color();
        private SimpleRenderer renderer;
        private int alpha = 255;

        private Instance() {
        }

        public void render() {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            this.renderBackground();
        }

        public void render(SimpleRenderer renderer) {
            renderer.glRender(new GLRenderable(this){
                final /* synthetic */ Instance this$1;
                {
                    this.this$1 = instance;
                }

                public void render() {
                    GL11.glEnable((int)3553);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                }
            });
            this.renderBackground(renderer);
        }

        public void renderBackground(SimpleRenderer renderer) {
            this.renderer = renderer;
            current = null;
            this.drawBottomLeft();
            this.drawBottom();
            this.drawLeft();
            this.drawTopLeft();
            this.drawBottomRight();
            this.drawMiddle();
            this.drawTop();
            this.drawRight();
            this.drawTopRight();
            if (current != null) {
                renderer.glEnd();
                current = null;
            }
            renderer = null;
        }

        public void renderBackground() {
            this.renderBackground(SimpleRenderer.GL_RENDERER);
        }

        private int getW() {
            return this.bounds.getWidth() + Background.this.insets.getWidth() + Background.this.insets.getX();
        }

        private int getH() {
            return this.bounds.getHeight() + Background.this.insets.getHeight() + Background.this.insets.getY();
        }

        private void drawBottomLeft() {
            int w = Math.min(this.getW(), Background.this.bottom_left_image.getWidth());
            int h = Math.min(this.getH(), Background.this.bottom_left_image.getHeight());
            this.drawImage(Background.this.bottom_left_image, 0, 0, w, h);
        }

        private void drawBottom() {
            int w = this.getW() - (Background.this.bottom_left_image.getWidth() + Background.this.bottom_right_image.getWidth());
            int h = Math.min(Background.this.bottom_image.getHeight(), this.getH());
            this.drawImage(Background.this.bottom_image, Background.this.bottom_left_image.getWidth(), 0, w, h);
        }

        private void drawLeft() {
            int w = Math.min(Background.this.left_image.getWidth(), this.getW());
            int h = this.getH() - (Background.this.bottom_left_image.getHeight() + Background.this.top_left_image.getHeight());
            this.drawImage(Background.this.left_image, 0, Background.this.left_image.getY(), w, h);
        }

        private void drawTopLeft() {
            int y = Math.max(Background.this.bottom_left_image.getHeight(), this.getH() - Background.this.top_left_image.getHeight());
            int w = Math.min(this.getW(), Background.this.top_left_image.getWidth());
            int h = Math.min(this.getH() - y, Background.this.top_left_image.getHeight());
            this.drawImage(Background.this.top_left_image, 0, y, w, h);
        }

        private void drawBottomRight() {
            int x = Math.max(Background.this.bottom_left_image.getWidth(), this.getW() - Background.this.bottom_right_image.getWidth());
            int w = Math.min(this.getW() - x, Background.this.bottom_right_image.getWidth());
            int h = Math.min(this.getH(), Background.this.bottom_right_image.getHeight());
            this.drawImage(Background.this.bottom_right_image, x, 0, w, h);
        }

        private void drawMiddle() {
            int w = this.getW() - (Background.this.left_image.getWidth() + Background.this.right_image.getWidth());
            int h = this.getH() - (Background.this.bottom_image.getHeight() + Background.this.top_image.getHeight());
            this.drawImage(Background.this.middle_image, Background.this.middle_image.getX(), Background.this.middle_image.getY(), w, h);
        }

        private void drawTop() {
            int y = Math.max(Background.this.bottom_image.getHeight(), this.getH() - Background.this.top_image.getHeight());
            int w = this.getW() - (Background.this.top_left_image.getWidth() + Background.this.top_right_image.getWidth());
            int h = Math.min(Background.this.top_image.getHeight(), this.getH());
            this.drawImage(Background.this.top_image, Background.this.top_left_image.getWidth(), y, w, h);
        }

        private void drawRight() {
            int x = Math.max(Background.this.left_image.getWidth(), this.getW() - Background.this.right_image.getWidth());
            int w = Math.min(Background.this.right_image.getWidth(), this.getW());
            int h = this.getH() - (Background.this.bottom_right_image.getHeight() + Background.this.top_right_image.getHeight());
            this.drawImage(Background.this.right_image, x, Background.this.bottom_right_image.getHeight(), w, h);
        }

        private void drawTopRight() {
            int x = Math.min(this.getW() - Background.this.top_right_image.getWidth(), this.getW());
            int y = Math.min(this.getH() - Background.this.top_right_image.getHeight(), this.getH());
            int w = this.getW() - x;
            int h = this.getH() - y;
            this.drawImage(Background.this.top_right_image, x, y, w, h);
        }

        private void drawImage(SpriteImage image, int x, int y, int w, int h) {
            if (w < 1 || h < 1) {
                return;
            }
            this.blit(image, x, y, w, h);
        }

        private void calcColorAtPoint(int x, int y) {
            float wid = this.getWidth();
            float hgt = this.getHeight();
            float fx = Math.min(wid, Math.max(0.0f, (float)(x - this.getRightInset())));
            float fy = Math.min(hgt, Math.max(0.0f, (float)(y - this.getTopInset())));
            double bottomLeftArea = fx * fy;
            double bottomRightArea = (wid - fx) * fy;
            double topLeftArea = fx * (hgt - fy);
            double topRightArea = (wid - fx) * (hgt - fy);
            double totalArea = wid * hgt;
            double bottomLeftRatio = bottomLeftArea / totalArea;
            double topLeftRatio = topLeftArea / totalArea;
            double bottomRightRatio = bottomRightArea / totalArea;
            double topRightRatio = topRightArea / totalArea;
            this.blendColor.set((int)((double)Background.this.bottomLeftColor.getRed() * topRightRatio + (double)Background.this.topLeftColor.getRed() * bottomRightRatio + (double)Background.this.bottomRightColor.getRed() * topLeftRatio + (double)Background.this.topRightColor.getRed() * bottomLeftRatio), (int)((double)Background.this.bottomLeftColor.getGreen() * topRightRatio + (double)Background.this.topLeftColor.getGreen() * bottomRightRatio + (double)Background.this.bottomRightColor.getGreen() * topLeftRatio + (double)Background.this.topRightColor.getGreen() * bottomLeftRatio), (int)((double)Background.this.bottomLeftColor.getBlue() * topRightRatio + (double)Background.this.topLeftColor.getBlue() * bottomRightRatio + (double)Background.this.bottomRightColor.getBlue() * topLeftRatio + (double)Background.this.topRightColor.getBlue() * bottomLeftRatio), (int)((double)Background.this.bottomLeftColor.getAlpha() * topRightRatio + (double)Background.this.topLeftColor.getAlpha() * bottomRightRatio + (double)Background.this.bottomRightColor.getAlpha() * topLeftRatio + (double)Background.this.topRightColor.getAlpha() * bottomLeftRatio));
            this.renderer.glColor4ub((byte)(this.blendColor.getRed() * this.instanceColor.getRed() / 255), (byte)(this.blendColor.getGreen() * this.instanceColor.getGreen() / 255), (byte)(this.blendColor.getBlue() * this.instanceColor.getBlue() / 255), (byte)(this.blendColor.getAlpha() * this.instanceColor.getAlpha() * this.alpha / 65025));
        }

        private void blit(SpriteImage image, int x, int y, int w, int h) {
            if (current != image.getTexture()) {
                if (current != null) {
                    this.renderer.glEnd();
                }
                current = image.getTexture();
                this.renderer.glRender(current);
                this.renderer.glBegin(7);
            }
            this.calcColorAtPoint(x, y);
            this.renderer.glTexCoord2f(image.getTx0(), image.getTy0());
            this.renderer.glVertex2f(x - Background.this.insets.getX() + this.bounds.getX(), y - Background.this.insets.getY() + this.bounds.getY());
            float tx1 = image.getTx1();
            this.calcColorAtPoint(x + w, y);
            this.renderer.glTexCoord2f(tx1, image.getTy0());
            this.renderer.glVertex2f(x + w - Background.this.insets.getX() + this.bounds.getX(), y - Background.this.insets.getY() + this.bounds.getY());
            float ty1 = image.getTy1();
            this.calcColorAtPoint(x + w, y + h);
            this.renderer.glTexCoord2f(tx1, ty1);
            this.renderer.glVertex2f(x + w - Background.this.insets.getX() + this.bounds.getX(), y + h - Background.this.insets.getY() + this.bounds.getY());
            this.calcColorAtPoint(x, y + h);
            this.renderer.glTexCoord2f(image.getTx0(), ty1);
            this.renderer.glVertex2f(x - Background.this.insets.getX() + this.bounds.getX(), y + h - Background.this.insets.getY() + this.bounds.getY());
        }

        public int getHeight() {
            return this.bounds.getHeight() + Background.this.insets.getHeight() + Background.this.insets.getY();
        }

        public void getSize(WritableDimension dest) {
            dest.setSize(this.bounds.getWidth() - Background.this.insets.getWidth() - Background.this.insets.getX(), this.bounds.getHeight() - Background.this.insets.getHeight() - Background.this.insets.getY());
        }

        public int getWidth() {
            return this.bounds.getWidth() - Background.this.insets.getWidth() - Background.this.insets.getX();
        }

        public void setBounds(ReadableRectangle bounds) {
            this.bounds = bounds;
        }

        public ReadableRectangle getBounds() {
            return this.bounds;
        }

        public void setColor(ReadableColor src) {
            this.instanceColor = src;
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }

        public ReadableColor getColor() {
            return this.instanceColor;
        }

        public int getXInset() {
            return Background.this.insets.getX();
        }

        public int getYInset() {
            return Background.this.insets.getY();
        }

        public int getRightInset() {
            return Background.this.insets.getWidth();
        }

        public int getTopInset() {
            return Background.this.insets.getHeight();
        }
    }
}

