/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.opengl.GLRenderableObject;
import com.shavenpuppy.jglib.opengl.GLResource;
import com.shavenpuppy.jglib.opengl.GLUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.OpenGLException;

public class GLVertexBufferObject
extends GLResource
implements GLRenderableObject {
    private int size;
    private final int type;
    private final int usage;
    private transient int id;
    private transient boolean mapped;
    private transient boolean cleared;
    private transient ByteBuffer buffer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.GLVertexBufferObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GLVertexBufferObject(int size, int type, int usage) {
        this.size = size;
        this.type = type;
        this.usage = usage;
    }

    public GLVertexBufferObject(int type, int usage) {
        this.size = 0;
        this.type = type;
        this.usage = usage;
    }

    protected void doGLCreate() {
        GLUtil.scratch.ints.clear().limit(1);
        ARBVertexBufferObject.glGenBuffersARB((IntBuffer)GLUtil.scratch.ints);
        this.id = GLUtil.scratch.ints.get(0);
    }

    public void clear() {
        if (!this.cleared) {
            ARBVertexBufferObject.glBufferDataARB((int)this.type, (long)this.size, (int)this.usage);
            this.cleared = true;
        }
    }

    protected void doGLDestroy() {
        if (this.id != 0) {
            GLUtil.scratch.ints.clear().limit(1);
            GLUtil.scratch.ints.put(0, this.id);
            GLUtil.scratch.ints.clear().limit(1);
            this.unmap();
            ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)GLUtil.scratch.ints);
        }
    }

    public ByteBuffer map(int size) {
        if (!this.mapped) {
            if (this.size != size) {
                this.size = size;
                this.clear();
            }
            if (this.buffer != null && this.buffer.capacity() < size) {
                this.buffer = null;
            }
            ByteBuffer old = this.buffer;
            this.buffer = ARBVertexBufferObject.glMapBufferARB((int)this.type, (int)35001, (long)size, (ByteBuffer)this.buffer);
            if (this.buffer == null) {
                throw new OpenGLException("Failed to map buffer " + this);
            }
            if (this.buffer != old) {
                // empty if block
            }
            this.buffer.order(ByteOrder.nativeOrder()).clear().limit(size);
            if (!$assertionsDisabled && this.buffer == null) {
                throw new AssertionError();
            }
            this.mapped = true;
            this.cleared = false;
        }
        return this.buffer;
    }

    public ByteBuffer map() {
        if (!this.mapped) {
            if (!$assertionsDisabled && this.size <= 0) {
                throw new AssertionError();
            }
            this.clear();
            ByteBuffer old = this.buffer;
            this.buffer = ARBVertexBufferObject.glMapBufferARB((int)this.type, (int)35001, (long)this.size, (ByteBuffer)this.buffer);
            if (this.buffer == null) {
                throw new OpenGLException("Failed to map a buffer " + this.size + " bytes long");
            }
            if (this.buffer != old) {
                // empty if block
            }
            this.buffer.order(ByteOrder.nativeOrder()).clear().limit(this.size);
            if (!$assertionsDisabled && this.buffer == null) {
                throw new AssertionError();
            }
            this.mapped = true;
            this.cleared = false;
        }
        return this.buffer;
    }

    public void orphan() {
        ARBVertexBufferObject.glMapBufferARB((int)this.type, (int)this.usage, (long)this.size, null);
    }

    public boolean unmap() {
        if (this.mapped) {
            this.mapped = false;
            return ARBVertexBufferObject.glUnmapBufferARB((int)this.type);
        }
        return true;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public String toString() {
        return "GLVertexBufferObject[" + this.id + ", " + this.size + ", " + this.isCreated() + "]";
    }

    public void render() {
        ARBVertexBufferObject.glBindBufferARB((int)this.type, (int)this.id);
    }

    public int getID() {
        return this.id;
    }
}

