/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static void setGLColor(ReadableColor color) {
        ColorUtil.setGLColor(color, SimpleRenderer.GL_RENDERER);
    }

    public static void setGLColor(ReadableColor color, SimpleRenderer renderer) {
        renderer.glColor4ub(color.getRedByte(), color.getGreenByte(), color.getBlueByte(), color.getAlphaByte());
    }

    public static void setGLColor(ReadableColor color, int alpha) {
        ColorUtil.setGLColor(color, alpha, SimpleRenderer.GL_RENDERER);
    }

    public static void setGLColor(ReadableColor color, int alpha, SimpleRenderer renderer) {
        renderer.glColor4ub(color.getRedByte(), color.getGreenByte(), color.getBlueByte(), (byte)(color.getAlpha() * alpha >> 8));
    }

    public static void setGLColor(ReadableColor color1, ReadableColor color2) {
        ColorUtil.setGLColor(color1, color2, SimpleRenderer.GL_RENDERER);
    }

    public static void setGLColor(ReadableColor color1, ReadableColor color2, SimpleRenderer renderer) {
        byte red = (byte)(color1.getRed() * color2.getRed() / 255);
        byte green = (byte)(color1.getGreen() * color2.getGreen() / 255);
        byte blue = (byte)(color1.getBlue() * color2.getBlue() / 255);
        byte alpha = (byte)(color1.getAlpha() * color2.getAlpha() / 255);
        renderer.glColor4ub(red, green, blue, alpha);
    }

    public static Color blendColor(ReadableColor color1, ReadableColor color2, Color dest) {
        if (dest == null) {
            dest = new Color();
        }
        dest.set((byte)(color1.getRed() * color2.getRed() / 255), (byte)(color1.getGreen() * color2.getGreen() / 255), (byte)(color1.getBlue() * color2.getBlue() / 255), (byte)(color1.getAlpha() * color2.getAlpha() / 255));
        return dest;
    }

    public static Color setAlpha(ReadableColor color, int alpha, Color dest) {
        if (dest == null) {
            dest = new Color();
        }
        dest.set(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * alpha / 255);
        return dest;
    }
}

