/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Resources {
    public static final boolean DEBUG = false;
    private static boolean runMode;
    private static final HashMap resourceMap;
    private static final HashMap classToTagMap;
    private static final HashMap tagToClassMap;
    static Thread allocationThread;
    private static final List all;
    private static final Set unnamedSet;
    private static final ArrayList creating;
    private static final ArrayList destroying;
    private static int numQueued;
    private static int numCreated;
    private static CreatingCallback creatingCallback;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Resources");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean bl = $assertionsDisabled = !clazz.desiredAssertionStatus();
        if (System.getProperty("java.protocol.handler.pkgs") == null) {
            System.getProperties().put("java.protocol.handler.pkgs", "com.shavenpuppy.jglib.resources.protocol");
        }
        resourceMap = new HashMap(256, 0.25f);
        classToTagMap = new HashMap();
        tagToClassMap = new HashMap();
        allocationThread = Thread.currentThread();
        all = new LinkedList();
        unnamedSet = new HashSet();
        creating = new ArrayList();
        destroying = new ArrayList();
    }

    private Resources() {
    }

    public static synchronized void setAllocationThread(Thread allocationThread) {
        if (allocationThread != Resources.allocationThread) {
            while (destroying.size() > 0) {
                try {
                    System.out.println("Trying to set new allocation thread " + allocationThread + " (old=" + Resources.allocationThread + ")");
                    System.out.println("Still " + destroying.size() + " things in the destruction queue");
                    Iterator i = destroying.iterator();
                    while (i.hasNext()) {
                        System.out.println("-->" + i.next());
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("com.shavenpuppy.jglib.Resources");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    clazz.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Resources.allocationThread = allocationThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource peek(String name) {
        Resource ret = null;
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            ret = (Resource)resourceMap.get(name.toLowerCase());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource get(String name) {
        Resource ret = null;
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            ret = (Resource)resourceMap.get(name.toLowerCase());
        }
        if (ret == null) {
            System.err.println("WARNING: Resource '" + name + "' not found");
            return null;
        }
        if (!ret.isCreated()) {
            if (creatingCallback != null) {
                creatingCallback.onCreating(ret);
            }
            ++numQueued;
            ret.create();
            ++numCreated;
            --numQueued;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String name) {
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            return resourceMap.containsKey(name.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(Resource resource) {
        if (resource.getName() == null) {
            throw new RuntimeException("Unnamed resource " + resource + " cannot be put in the named set");
        }
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            Resource old = resourceMap.put(resource.getName().toLowerCase(), resource);
            if (old != null) {
                old.deregister();
            }
            resource.register();
            all.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Resource resource) {
        if (resource.getName() != null) {
            throw new RuntimeException("Named resource " + resource + " cannot be added to the unnamed set.");
        }
        Set set = unnamedSet;
        synchronized (set) {
            unnamedSet.add(resource);
            resource.register();
            all.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Resource resource) {
        Set set = unnamedSet;
        synchronized (set) {
            if (unnamedSet.remove(resource)) {
                resource.deregister();
            }
            all.remove(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource remove(String name) {
        Resource ret;
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            ret = (Resource)resourceMap.remove(name.toLowerCase());
            all.remove(ret);
        }
        if (ret != null) {
            ret.destroy();
            ret.deregister();
        }
        return ret;
    }

    static synchronized Resource forget(Resource resource) {
        all.remove(resource);
        if (resource.getName() != null) {
            return (Resource)resourceMap.remove(resource.getName());
        }
        if (unnamedSet.contains(resource)) {
            unnamedSet.remove(resource);
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void manage() {
        Resource res;
        int i;
        int n;
        if (!$assertionsDisabled && Thread.currentThread() != allocationThread) {
            throw new AssertionError((Object)"manage() may only be called in the main thread.");
        }
        boolean notify = false;
        ArrayList arrayList = destroying;
        synchronized (arrayList) {
            n = destroying.size();
            if (n > 0) {
                notify = true;
                i = 0;
                while (i < n) {
                    res = (Resource)destroying.get(i);
                    try {
                        Resources.deallocate(res);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                destroying.clear();
            }
        }
        arrayList = creating;
        synchronized (arrayList) {
            n = creating.size();
            i = 0;
            while (i < n) {
                res = (Resource)creating.get(i);
                Resources.allocate(res);
                ++i;
            }
            creating.clear();
        }
        if (notify) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz.notifyAll();
        }
    }

    public static synchronized void save(OutputStream os) throws IOException {
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new BufferedOutputStream(os);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(all);
            oos.flush();
            bos.flush();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized void load(InputStream is) throws IOException, ClassNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(bis);
        List newAll = (List)ois.readObject();
        Iterator i = newAll.iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (res.getName() != null) {
                Resources.put(res);
                continue;
            }
            Resources.add(res);
        }
    }

    public static void clear() {
        Iterator<Object> i = resourceMap.values().iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (res == null) continue;
            if (res.isCreated()) {
                res.destroy();
            }
            res.deregister();
        }
        resourceMap.clear();
        i = unnamedSet.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).destroy();
        }
        unnamedSet.clear();
        all.clear();
        System.gc();
    }

    public static void reset() {
        Iterator<Object> i = resourceMap.values().iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (res == null || !res.isCreated()) continue;
            res.destroy();
        }
        i = unnamedSet.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).destroy();
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allocate(Resource res) {
        Resource resource = res;
        synchronized (resource) {
            if (Thread.currentThread() == allocationThread) {
                res.doCreate();
                res.created = true;
                res.queued = false;
                res.notifyAll();
            } else {
                ArrayList arrayList = creating;
                synchronized (arrayList) {
                    creating.add(res);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void queue(Resource res) {
        Resource resource = res;
        synchronized (resource) {
            ArrayList arrayList = creating;
            synchronized (arrayList) {
                creating.add(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deallocate(Resource res) {
        Resource resource = res;
        synchronized (resource) {
            if (Thread.currentThread() == allocationThread) {
                res.doDestroy();
                res.created = false;
                res.dying = false;
                res.notifyAll();
            } else {
                ArrayList arrayList = destroying;
                synchronized (arrayList) {
                    System.out.println("Added " + res + " to destruction queue");
                    destroying.add(res);
                }
            }
        }
    }

    public static int getNumCreated() {
        return numCreated;
    }

    public static int getNumQueued() {
        return numQueued;
    }

    public static CreatingCallback getCreatingCallback() {
        return creatingCallback;
    }

    public static void setCreatingCallback(CreatingCallback creatingCallback) {
        Resources.creatingCallback = creatingCallback;
    }

    public static ArrayList list(Class clazz) {
        LinkedList ret = new LinkedList();
        Iterator i = resourceMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!((Resource)entry.getValue()).named || !clazz.isAssignableFrom(entry.getValue().getClass())) continue;
            ret.add(entry.getValue());
        }
        return new ArrayList(ret);
    }

    public static Thread getAllocationThread() {
        return allocationThread;
    }

    public static void setRunMode(boolean runMode) {
        Resources.runMode = runMode;
    }

    public static boolean isRunMode() {
        return runMode;
    }

    public static void registerTag(Class clazz, String tag) {
        classToTagMap.put(clazz, tag);
        tagToClassMap.put(tag, clazz);
    }

    public static String getTag(Class clazz) {
        return (String)classToTagMap.get(clazz);
    }

    public static Class getMapping(String tag) {
        return (Class)tagToClassMap.get(tag);
    }

    public static void create() {
        Iterator<Object> i = resourceMap.values().iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).create();
        }
        i = unnamedSet.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).create();
        }
    }

    public static interface CreatingCallback {
        public void onCreating(Resource var1);
    }
}

