/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jheora.Comment;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.State;
import com.fluendo.jheora.YUVBuffer;
import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.plugin.OggPayload;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import java.util.List;

public class TheoraDec
extends Element
implements OggPayload {
    private static final byte[] signature = new byte[]{-128, 116, 104, 101, 111, 114, 97};
    private Info ti;
    private Comment tc;
    private State ts;
    private Packet op;
    private int packet;
    private YUVBuffer yuv;
    private long lastTs;
    private boolean needKeyframe;
    private boolean haveDecoder = false;
    private Pad srcPad = new Pad(1, "src"){

        protected boolean eventFunc(Event event) {
            return TheoraDec.this.sinkPad.pushEvent(event);
        }
    };
    private Pad sinkPad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            boolean result;
            switch (event.getType()) {
                case 1: {
                    result = TheoraDec.this.srcPad.pushEvent(event);
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, "synced " + this);
                        break;
                    }
                }
                case 2: {
                    result = TheoraDec.this.srcPad.pushEvent(event);
                    break;
                }
                case 3: {
                    Debug.log(3, "got EOS " + this);
                    result = TheoraDec.this.srcPad.pushEvent(event);
                    break;
                }
                default: {
                    result = TheoraDec.this.srcPad.pushEvent(event);
                }
            }
            return result;
        }

        protected int chainFunc(Buffer buf) {
            int result;
            Debug.log(4, String.valueOf(this.parent.getName()) + " <<< " + buf);
            ((TheoraDec)TheoraDec.this).op.packet_base = buf.data;
            ((TheoraDec)TheoraDec.this).op.packet = buf.offset;
            ((TheoraDec)TheoraDec.this).op.bytes = buf.length;
            ((TheoraDec)TheoraDec.this).op.b_o_s = TheoraDec.this.packet == 0 ? 1 : 0;
            ((TheoraDec)TheoraDec.this).op.e_o_s = 0;
            ((TheoraDec)TheoraDec.this).op.packetno = TheoraDec.this.packet;
            long timestamp = buf.timestamp;
            if (buf.isFlagSet(1)) {
                Debug.log(3, "theora: got discont");
                TheoraDec.this.needKeyframe = true;
                TheoraDec.this.lastTs = -1L;
            }
            if (TheoraDec.this.packet < 3) {
                if (TheoraDec.this.takeHeader(TheoraDec.this.op) < 0) {
                    buf.free();
                    Debug.log(1, "does not contain Theora video data.");
                    return -5;
                }
                if (TheoraDec.this.packet == 2) {
                    TheoraDec.this.ts.decodeInit(TheoraDec.this.ti);
                    Debug.log(3, "theora dimension: " + ((TheoraDec)TheoraDec.this).ti.width + "x" + ((TheoraDec)TheoraDec.this).ti.height);
                    if (((TheoraDec)TheoraDec.this).ti.aspect_denominator == 0) {
                        ((TheoraDec)TheoraDec.this).ti.aspect_numerator = 1;
                        ((TheoraDec)TheoraDec.this).ti.aspect_denominator = 1;
                    }
                    Debug.log(3, "theora offset: " + ((TheoraDec)TheoraDec.this).ti.offset_x + "," + ((TheoraDec)TheoraDec.this).ti.offset_y);
                    Debug.log(3, "theora frame: " + ((TheoraDec)TheoraDec.this).ti.frame_width + "," + ((TheoraDec)TheoraDec.this).ti.frame_height);
                    Debug.log(3, "theora aspect: " + ((TheoraDec)TheoraDec.this).ti.aspect_numerator + "/" + ((TheoraDec)TheoraDec.this).ti.aspect_denominator);
                    Debug.log(3, "theora framerate: " + ((TheoraDec)TheoraDec.this).ti.fps_numerator + "/" + ((TheoraDec)TheoraDec.this).ti.fps_denominator);
                    this.caps = new Caps("video/raw");
                    this.caps.setFieldInt("width", ((TheoraDec)TheoraDec.this).ti.frame_width);
                    this.caps.setFieldInt("height", ((TheoraDec)TheoraDec.this).ti.frame_height);
                    this.caps.setFieldInt("aspect_x", ((TheoraDec)TheoraDec.this).ti.aspect_numerator);
                    this.caps.setFieldInt("aspect_y", ((TheoraDec)TheoraDec.this).ti.aspect_denominator);
                }
                buf.free();
                TheoraDec theoraDec = TheoraDec.this;
                theoraDec.packet = theoraDec.packet + 1;
                return 0;
            }
            if ((((TheoraDec)TheoraDec.this).op.packet_base[((TheoraDec)TheoraDec.this).op.packet] & 0x80) == 128) {
                Debug.log(3, "ignoring header");
                return 0;
            }
            if (TheoraDec.this.needKeyframe && TheoraDec.this.ts.isKeyframe(TheoraDec.this.op)) {
                TheoraDec.this.needKeyframe = false;
            }
            if (timestamp != -1L) {
                TheoraDec.this.lastTs = timestamp;
            } else if (TheoraDec.this.lastTs != -1L) {
                long add = 1000000L * (long)((TheoraDec)TheoraDec.this).ti.fps_denominator / (long)((TheoraDec)TheoraDec.this).ti.fps_numerator;
                TheoraDec theoraDec = TheoraDec.this;
                theoraDec.lastTs = theoraDec.lastTs + add;
                timestamp = TheoraDec.this.lastTs;
            }
            if (!TheoraDec.this.needKeyframe) {
                block16: {
                    if (TheoraDec.this.ts.decodePacketin(TheoraDec.this.op) != 0) {
                        Debug.log(1, "Bad Theora packet. Most likely not fatal, hoping for better luck next packet.");
                    }
                    if (TheoraDec.this.ts.decodeYUVout(TheoraDec.this.yuv) == 0) break block16;
                    buf.free();
                    TheoraDec.this.postMessage(Message.newError(this, "Error getting the Theora picture"));
                    Debug.log(1, "Error getting the picture.");
                    return -5;
                }
                try {
                    buf.object = TheoraDec.this.yuv.getObject(((TheoraDec)TheoraDec.this).ti.offset_x, ((TheoraDec)TheoraDec.this).ti.offset_y, ((TheoraDec)TheoraDec.this).ti.frame_width, ((TheoraDec)TheoraDec.this).ti.frame_height);
                    buf.caps = this.caps;
                    buf.timestamp = timestamp;
                    Debug.log(4, String.valueOf(this.parent.getName()) + " >>> " + buf);
                    result = TheoraDec.this.srcPad.push(buf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TheoraDec.this.postMessage(Message.newError(this, e.getMessage()));
                    result = -5;
                }
            } else {
                result = 0;
                buf.free();
            }
            TheoraDec theoraDec = TheoraDec.this;
            theoraDec.packet = theoraDec.packet + 1;
            return result;
        }

        protected boolean activateFunc(int mode) {
            return true;
        }
    };

    public boolean isType(Packet op) {
        return this.typeFind(op.packet_base, op.packet, op.bytes) > 0;
    }

    public int takeHeader(Packet op) {
        int ret = this.ti.decodeHeader(this.tc, op);
        byte header = op.packet_base[op.packet];
        if (header == -126) {
            this.ts.decodeInit(this.ti);
            this.haveDecoder = true;
        }
        return ret;
    }

    public boolean isHeader(Packet op) {
        return (op.packet_base[op.packet] & 0x80) == 128;
    }

    public boolean isKeyFrame(Packet op) {
        return this.ts.isKeyframe(op);
    }

    public boolean isDiscontinuous() {
        return false;
    }

    public long getFirstTs(List packets) {
        int len = packets.size();
        Buffer data = null;
        int i = 0;
        while (i < len) {
            data = (Buffer)packets.get(i);
            if (data.time_offset != -1L) break;
            ++i;
        }
        if (i == packets.size() || data == null) {
            return -1L;
        }
        long time = this.granuleToTime(data.time_offset);
        data = (Buffer)packets.get(0);
        data.timestamp = time - (long)(i + 1) * (1000000L * (long)this.ti.fps_denominator / (long)this.ti.fps_numerator);
        return time;
    }

    public long granuleToTime(long gp) {
        if (gp < 0L || !this.haveDecoder) {
            return -1L;
        }
        long res = (long)(this.ts.granuleTime(gp) * 1000000.0);
        return res;
    }

    public TheoraDec() {
        this.ti = new Info();
        this.tc = new Comment();
        this.ts = new State();
        this.yuv = new YUVBuffer();
        this.op = new Packet();
        this.addPad(this.srcPad);
        this.addPad(this.sinkPad);
    }

    protected int changeState(int transition) {
        switch (transition) {
            case 18: {
                this.lastTs = -1L;
                this.packet = 0;
                this.needKeyframe = true;
                break;
            }
        }
        int res = super.changeState(transition);
        switch (transition) {
            case 33: {
                this.ti.clear();
                this.tc.clear();
                this.ts.clear();
                break;
            }
        }
        return res;
    }

    public String getFactoryName() {
        return "theoradec";
    }

    public String getMime() {
        return "video/x-theora";
    }

    public int typeFind(byte[] data, int offset, int length) {
        if (MemUtils.startsWith(data, offset, length, signature)) {
            return 10;
        }
        return -1;
    }
}

