/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Debug;
import java.util.Vector;

public class Selector
extends Element {
    private Vector sinks = new Vector();
    int selected = -1;
    Pad selectedPad = null;
    private Pad srcPad = new Pad(1, "src"){

        protected boolean eventFunc(Event event) {
            boolean ret = true;
            int n = 0;
            while (n < Selector.this.sinks.size()) {
                ret &= ((Pad)Selector.this.sinks.elementAt(n)).pushEvent(event);
                ++n;
            }
            return ret;
        }
    };

    public Pad requestSinkPad(Pad peer) {
        Pad pad = new Pad(2, "sink" + this.sinks.size()){

            protected boolean eventFunc(Event event) {
                if (Selector.this.selectedPad == this) {
                    return Selector.this.srcPad.pushEvent(event);
                }
                return true;
            }

            protected int chainFunc(Buffer buf) {
                int result = 0;
                Debug.debug("Selector got " + buf.caps + " buffer on " + this.toString());
                if (Selector.this.selectedPad == this) {
                    Debug.debug("what a coincidence, we're selected - pushing");
                    result = Selector.this.srcPad.push(buf);
                }
                return result;
            }

            protected boolean activateFunc(int mode) {
                return true;
            }
        };
        this.sinks.addElement(pad);
        this.addPad(pad);
        return pad;
    }

    public Selector() {
        this.addPad(this.srcPad);
    }

    public boolean setProperty(String name, Object value) {
        if (name.equals("selected")) {
            int new_selected = Integer.valueOf(value.toString());
            Debug.info("Selector: request to select " + new_selected + " (from " + this.selected + "), within 0-" + (this.sinks.size() - 1));
            if (new_selected < 0 || new_selected >= this.sinks.size()) {
                this.selected = -1;
                this.selectedPad = null;
            } else {
                this.selected = new_selected;
                this.selectedPad = (Pad)this.sinks.elementAt(this.selected);
            }
        } else {
            return super.setProperty(name, value);
        }
        return true;
    }

    public Object getProperty(String name) {
        if (name.equals("selected")) {
            return new Integer(this.selected);
        }
        return super.getProperty(name);
    }

    public String getFactoryName() {
        return "selector";
    }
}

