/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Message;
import com.fluendo.plugin.AudioSink;
import com.fluendo.utils.Debug;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class AudioSinkJ2
extends AudioSink {
    public static final int SEGSIZE = 8192;
    private SourceDataLine line = null;
    private int channels;
    private long samplesWritten;
    static /* synthetic */ Class class$0;

    protected AudioSink.RingBuffer createRingBuffer() {
        return new AudioSink.RingBuffer();
    }

    protected boolean open(AudioSink.RingBuffer ring) {
        this.channels = ring.channels;
        this.line = this.openLine(ring.channels, ring.rate);
        if (this.line == null) {
            this.postMessage(Message.newError(this, "Could not open audio device."));
            return false;
        }
        Debug.log(3, "line info: available: " + this.line.available());
        Debug.log(3, "line info: buffer: " + this.line.getBufferSize());
        Debug.log(3, "line info: framePosition: " + this.line.getFramePosition());
        ring.segSize = 8192;
        ring.segTotal = this.line.getBufferSize() / ring.segSize;
        while (ring.segTotal < 4) {
            ring.segSize >>= 1;
            ring.segTotal = this.line.getBufferSize() / ring.segSize;
        }
        ring.emptySeg = new byte[ring.segSize];
        this.samplesWritten = 0L;
        this.line.start();
        return true;
    }

    protected SourceDataLine openLine(int channels, int rate) {
        AudioFormat format = new AudioFormat(rate, 16, channels, true, true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, format);
        SourceDataLine line = null;
        try {
            Mixer.Info[] mixers = AudioSystem.getMixerInfo();
            int i = 0;
            while (i < mixers.length) {
                Debug.log(3, "mixer description: " + mixers[i].getDescription() + ", vendor: " + mixers[i].getVendor());
                String desc = mixers[i].getDescription();
                String vendor = mixers[i].getVendor();
                if ((desc.indexOf("ALSA") >= 0 || vendor.indexOf("ALSA") >= 0) && desc.indexOf("IEC958") < 0) {
                    try {
                        Line.Info[] lines = AudioSystem.getMixer(mixers[i]).getSourceLineInfo(info);
                        int j = 0;
                        while (j < lines.length) {
                            Debug.log(3, "Mixer supports line: " + lines[j].toString());
                            AudioFormat[] formats = ((DataLine.Info)lines[j]).getFormats();
                            int k = 0;
                            while (k < formats.length) {
                                Debug.log(3, "Format: " + formats[k].toString());
                                ++k;
                            }
                            ++j;
                        }
                        Debug.log(3, "Attempting to get a line from ALSA mixer");
                        line = (SourceDataLine)AudioSystem.getMixer(mixers[i]).getLine(info);
                        line.open(format);
                        break;
                    }
                    catch (Exception e) {
                        if (line != null) {
                            line.close();
                            line = null;
                        }
                        Debug.log(3, "mixer: " + mixers[i].getDescription() + " failed: " + e);
                    }
                }
                ++i;
            }
            if (line == null) {
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(format);
            }
        }
        catch (LineUnavailableException e) {
            Debug.error(e.toString());
            return null;
        }
        catch (Exception e) {
            Debug.error(e.toString());
            return null;
        }
        return line;
    }

    public boolean test() {
        SourceDataLine line = this.openLine(2, 44000);
        if (line == null) {
            return false;
        }
        line.close();
        return true;
    }

    protected boolean close(AudioSink.RingBuffer ring) {
        this.line.stop();
        this.line.close();
        return true;
    }

    protected int write(byte[] data, int offset, int length) {
        int written;
        block6: {
            int available;
            written = 0;
            if (offset < 0 || offset >= data.length || offset + length > data.length || length <= 0) {
                Debug.debug("Invalid audio write offset=" + offset + ", length=" + length + ", data.length=" + data.length);
                return length;
            }
            while (length > (available = this.line.available())) {
                if (available > 0) {
                    Debug.debug("Doing partial audio write of " + available + " bytes");
                    written += this.line.write(data, offset, available);
                    offset += available;
                    length -= available;
                }
                if (length > 0) {
                    try {
                        AudioFormat format = this.line.getFormat();
                        long sleepTime = (long)((float)(this.line.getBufferSize() * 1000) / format.getSampleRate() / (float)format.getSampleSizeInBits() * 8.0f / 4.0f);
                        Debug.debug("Sleeping for " + sleepTime + "ms");
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break block6;
            }
            Debug.debug("Doing complete audio write of " + length + " bytes");
            written += this.line.write(data, offset, length);
        }
        this.samplesWritten += (long)(written / (2 * this.channels));
        return written;
    }

    protected long delay() {
        int frame = this.line.getFramePosition();
        long delay = this.samplesWritten - (long)frame;
        return delay;
    }

    protected void reset() {
        Debug.log(4, "reset audio: " + this.line);
        this.line.flush();
        this.samplesWritten = this.line.getFramePosition();
        Debug.log(4, "samples written: " + this.samplesWritten);
    }

    public String getFactoryName() {
        return "audiosinkj2";
    }
}

