/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.shared;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.HexDecoder;
import net.puppygames.gamecommerce.shared.HexEncoder;

public final class RegistrationDetails
implements Serializable {
    private static final String ENCODING = "UTF-8";
    private static final String OLD_ENCODING = "ISO-8859-1";
    public static final long serialVersionUID = 1L;
    public static final String PUBLIC_KEY = "308201b83082012c06072a8648ce3804013082011f02818100fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c70215009760508f15230bccb292b982a2eb840bf0581cf502818100f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a0381850002818100cfff377f44e641902f83c8bd33af2f02efddbb53466d3b0a889f4f936fc88e1f8f39427944d35c04f6c7d6afa38a642d54faa18117a9aeac6f1f5e98b2d8dbdff60406aa11fd43962d052319d883cf361ed65b0b35453fcb37496be9e69448ce4445626629ada640b2f16d56c4c062252bca564087d920ec7805ac2520dd4620";
    private static final String ENCRYPT_KEY = "name";
    private static final int EXPIRY_DAYS = 7;
    private static final String PASSWORD = "xyzzy";
    public static final String UNREGISTERED_NAME = "Unregistered";
    public static final String ALGORITHM = "DSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    private final String game;
    private String name;
    private String address;
    private String email;
    private byte[] regCode;
    private boolean exportable;
    static /* synthetic */ Class class$0;

    public RegistrationDetails(ResultSet rs) throws SQLException {
        this.game = rs.getString("game");
        this.regCode = HexDecoder.decode(rs.getString("regcode"));
        this.name = rs.getString(ENCRYPT_KEY);
        this.email = rs.getString("email");
        this.address = rs.getString("address");
    }

    public RegistrationDetails(String game) throws Exception {
        this.game = game;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.gamecommerce.shared.RegistrationDetails");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz).node(game);
        this.name = prefs.get(ENCRYPT_KEY, UNREGISTERED_NAME);
        this.address = prefs.get("address", "");
        this.email = prefs.get("email", "");
        String code = prefs.get("key", "unregistered");
        this.regCode = (byte[])(code.equals("unregistered") ? null : HexDecoder.decode(code));
    }

    public RegistrationDetails(String game, String name, String address, String email) {
        this(game, name, address, email, null);
    }

    public RegistrationDetails(String game, String name, String address, String email, String key) {
        this.game = game;
        this.name = name;
        this.address = address;
        this.email = email;
        this.regCode = HexDecoder.decode(key);
    }

    public void createNewRegistration(RegistrationDatabase db, String orderNo, String game, String authCode, Date purchaseDate, ConfigurationDetails configuration) throws SQLException {
        db.insertRegistration(HexEncoder.encode(this.regCode), this.name, this.address, this.email, authCode, purchaseDate, game, orderNo, configuration);
    }

    public void createNewRegistration(RegistrationDatabase db, String orderNo, String game, Date purchaseDate, ConfigurationDetails configuration) throws SQLException {
        db.insertRegistration(HexEncoder.encode(this.regCode), this.name, this.address, this.email, this.getAuthCode(), purchaseDate, game, orderNo, configuration);
    }

    public String getAuthCode() {
        String packedRegCode = HexEncoder.encode(this.regCode);
        return packedRegCode.substring(packedRegCode.length() - 14, packedRegCode.length());
    }

    public void toPreferences() {
        if (this.regCode == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.gamecommerce.shared.RegistrationDetails");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz).node(this.game);
        prefs.put(ENCRYPT_KEY, this.name);
        prefs.put("address", this.address);
        prefs.put("email", this.email);
        prefs.put("key", HexEncoder.encode(this.regCode));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
        }
    }

    public static void clearRegistration(String game) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.gamecommerce.shared.RegistrationDetails");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz).node(game);
        try {
            prefs.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean validate(PublicKey publicKey) throws Exception {
        if (this.regCode == null) {
            return false;
        }
        try {
            if (this.validate(publicKey, ENCODING)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        try {
            if (this.validate(publicKey, OLD_ENCODING)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return this.validate(publicKey, null);
    }

    private boolean validate(PublicKey publicKey, String encoding) throws Exception {
        Signature dsa = Signature.getInstance(SIGNATURE_ALGORITHM);
        dsa.initVerify(publicKey);
        if (encoding != null) {
            dsa.update(this.name.getBytes(encoding));
            dsa.update(this.address.getBytes(encoding));
            dsa.update(this.email.getBytes(encoding));
        } else {
            dsa.update(this.name.getBytes());
            dsa.update(this.address.getBytes());
            dsa.update(this.email.getBytes());
        }
        return dsa.verify(this.regCode);
    }

    public void register(PrivateKey privateKey) throws Exception {
        Signature dsa = Signature.getInstance(SIGNATURE_ALGORITHM);
        dsa.initSign(privateKey);
        dsa.update(this.name.getBytes(ENCODING));
        dsa.update(this.address.getBytes(ENCODING));
        dsa.update(this.email.getBytes(ENCODING));
        this.regCode = dsa.sign();
    }

    public void deregister() {
        try {
            Preferences prefs;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.puppygames.gamecommerce.shared.RegistrationDetails");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((prefs = Preferences.userNodeForPackage(clazz).node(this.game)).get(ENCRYPT_KEY, "").equals(this.name)) {
                this.toPreferences();
                prefs.put(ENCRYPT_KEY, String.valueOf(this.name) + " ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getRegCode() {
        return this.regCode;
    }

    public String toTitleScreen(boolean nameOnly) {
        if (this.name.equals(UNREGISTERED_NAME)) {
            return UNREGISTERED_NAME;
        }
        if (nameOnly) {
            return "Registered to " + this.name;
        }
        return "Registered to " + this.name + " (" + this.email + ") " + this.address;
    }

    public String toString() {
        if (this.name.equals(UNREGISTERED_NAME)) {
            return "RegistrationDetails[UNREGISTERED]";
        }
        return "RegistrationDetails[" + this.name + "/" + this.email + "/" + this.address + "]";
    }

    public static RegistrationDetails checkRegistration(String gameTitle) throws Exception {
        X509EncodedKeySpec publicKeySpec;
        RegistrationDetails testRegistrationDetails = new RegistrationDetails(gameTitle);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec = new X509EncodedKeySpec(HexDecoder.decode(PUBLIC_KEY)));
        if (testRegistrationDetails.validate(publicKey)) {
            return testRegistrationDetails;
        }
        return null;
    }

    public static interface RegistrationDatabase {
        public void insertRegistration(String var1, String var2, String var3, String var4, String var5, Date var6, String var7, String var8, ConfigurationDetails var9) throws SQLException;
    }
}

