/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.util.Util;
import invaders.Behaviour;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.Res;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;

public class Static
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_FADE = 1;
    private static final int PHASE_APPEAR = 2;
    private static final int FADE_DURATION = 60;
    private Range teleport;
    static /* synthetic */ Class class$0;

    public Static(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new StaticInstance(gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathStatic();
    }

    private static class StaticInstance
    extends Behaviour.Instance {
        private static final long serialVersionUID = 1L;
        int tick;
        int phase;
        transient Static behaviour;
        float newx;
        float newy;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("invaders.behaviours.Static");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public StaticInstance(Gidrah gidrah) {
            super(gidrah);
            this.behaviour = (Static)gidrah.getBehaviour();
            this.initTick();
            this.tick *= 2;
        }

        private void initTick() {
            this.tick = this.behaviour.teleport != null ? (int)this.behaviour.teleport.getValue() : 0;
        }

        public float getVX() {
            return 0.0f;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (Static)this.gidrah.getBehaviour();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        public boolean canCollide() {
            return this.phase == 0;
        }

        protected void doTick() {
            switch (this.phase) {
                case 0: {
                    if (this.behaviour.teleport == null || --this.tick > 0) break;
                    this.teleport();
                    break;
                }
                case 1: {
                    ++this.tick;
                    this.gidrah.setAlpha((int)LinearInterpolator.instance.interpolate(255.0f, 0.0f, (float)this.tick / 60.0f));
                    if (this.tick < 60) break;
                    this.phase = 2;
                    this.gidrah.setLocation(this.newx, this.newy);
                    this.tick = 0;
                    break;
                }
                case 2: {
                    ++this.tick;
                    this.gidrah.setAlpha((int)LinearInterpolator.instance.interpolate(0.0f, 255.0f, (float)this.tick / 60.0f));
                    if (this.tick < 60) break;
                    this.phase = 0;
                    this.initTick();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        void teleport() {
            int tries = 3;
            while (tries-- > 0) {
                float newx = Util.random((int)((int)this.gidrah.getRadius()), (int)Game.getWidth());
                float newy = Util.random((int)((int)(19.0f + this.gidrah.getRadius())), (int)((int)((float)Game.getHeight() - 80.0f)));
                ArrayList entities = Invaders.getGameState().getEntities();
                Iterator i = entities.iterator();
                while (i.hasNext()) {
                    Entity entity = (Entity)i.next();
                    if (entity == this.gidrah || !entity.canCollide() || !(entity.getDistanceTo(newx, newy) < this.gidrah.getRadius() + entity.getRadius())) continue;
                    this.moveTo(newx, newy);
                }
            }
            this.initTick();
        }

        private void moveTo(float newx, float newy) {
            Emitter e = Res.getTeleportEmitter().spawn((Screen)GameScreen.getInstance());
            e.setLocation(this.gidrah.getX(), this.gidrah.getY());
            this.phase = 1;
            this.newx = newx;
            this.newy = newy;
            this.tick = 0;
        }
    }
}

