/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import invaders.Invaders;
import invaders.ShopPowerDisplayFeature;
import invaders.ShopPrices;
import invaders.ShowPowerDisplay;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.puppygames.applet.Screen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ShopScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static ShopScreen instance;
    private static NumberFormat nf;
    private static final String BUY_SHIELDS = "buy_shields";
    private static final String BUY_GUN_POWER = "buy_gun_power";
    private static final String BUY_EXTRA_BULLETS = "buy_extra_bullets";
    private static final String BUY_SMARTBOMBS = "buy_smartbombs";
    private static final String BUY_ADDONS = "buy_addons";
    private static final String BUY_SHIP_SPEED = "buy_ship_speed";
    private static final String CONTINUE = "continue";
    private ShopPowerDisplayFeature shieldsDisplay;
    private ShopPowerDisplayFeature gunPowerDisplay;
    private ShopPowerDisplayFeature extraBulletsDisplay;
    private ShopPowerDisplayFeature smartBombsDisplay;
    private ShopPowerDisplayFeature addOnsDisplay;
    private ShopPowerDisplayFeature shipSpeedDisplay;
    private String moneyFont;
    private int moneyX;
    private int moneyY;
    private transient ShowPowerDisplay shieldsInstance;
    private transient ShowPowerDisplay gunPowerInstance;
    private transient ShowPowerDisplay extraBulletsInstance;
    private transient ShowPowerDisplay smartBombsInstance;
    private transient ShowPowerDisplay addOnsInstance;
    private transient ShowPowerDisplay shipSpeedInstance;
    private transient GLFont moneyFontResource;
    private transient GLString moneyLabel;
    boolean mDown;

    static {
        nf = DecimalFormat.getIntegerInstance();
        nf.setGroupingUsed(true);
    }

    public ShopScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        instance = this;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void doCreateScreen() {
        this.moneyLabel = new GLString(8);
        this.moneyLabel.setFont(this.moneyFontResource);
        this.moneyLabel.setLocation(this.moneyX, this.moneyY);
        this.shieldsDisplay.create();
        this.gunPowerDisplay.create();
        this.extraBulletsDisplay.create();
        this.smartBombsDisplay.create();
        this.addOnsDisplay.create();
        this.shipSpeedDisplay.create();
    }

    protected void onClicked(String id) {
        if (BUY_SHIELDS.equals(id)) {
            Invaders.getGameState().buyShields();
            this.updateBars();
        } else if (BUY_EXTRA_BULLETS.equals(id)) {
            Invaders.getGameState().buyExtraBullets();
            this.updateBars();
        } else if (BUY_GUN_POWER.equals(id)) {
            Invaders.getGameState().buyGunPower();
            this.updateBars();
        } else if (BUY_SMARTBOMBS.equals(id)) {
            Invaders.getGameState().buySmartBomb();
            this.updateBars();
        } else if (BUY_ADDONS.equals(id)) {
            Invaders.getGameState().buyAddOn();
            this.updateBars();
        } else if (BUY_SHIP_SPEED.equals(id)) {
            Invaders.getGameState().buyShipSpeed();
            this.updateBars();
        } else if (CONTINUE.equals(id)) {
            Invaders.getGameState().nextLevel();
        }
    }

    protected void onOpen() {
        this.shieldsInstance = this.shieldsDisplay.spawn(this);
        this.extraBulletsInstance = this.extraBulletsDisplay.spawn(this);
        this.gunPowerInstance = this.gunPowerDisplay.spawn(this);
        this.smartBombsInstance = this.smartBombsDisplay.spawn(this);
        this.addOnsInstance = this.addOnsDisplay.spawn(this);
        this.shipSpeedInstance = this.shipSpeedDisplay.spawn(this);
        this.requestFocus(null);
        this.updateBars();
    }

    protected void doCleanup() {
        this.shieldsInstance.cleanup();
        this.extraBulletsInstance.cleanup();
        this.gunPowerInstance.cleanup();
        this.smartBombsInstance.cleanup();
        this.addOnsInstance.cleanup();
        this.shipSpeedInstance.cleanup();
        this.shieldsInstance = null;
        this.extraBulletsInstance = null;
        this.gunPowerInstance = null;
        this.smartBombsInstance = null;
        this.addOnsInstance = null;
        this.shipSpeedInstance = null;
    }

    protected void doTick() {
        Keyboard.isKeyDown((int)50);
        this.mDown = false;
    }

    private void updateBars() {
        this.getArea(BUY_SHIELDS).setEnabled(Invaders.getGameState().canBuyShields());
        this.getArea(BUY_EXTRA_BULLETS).setEnabled(Invaders.getGameState().canBuyExtraBullets());
        this.getArea(BUY_GUN_POWER).setEnabled(Invaders.getGameState().canBuyGunPower());
        this.getArea(BUY_SMARTBOMBS).setEnabled(Invaders.getGameState().canBuySmartBombs());
        this.getArea(BUY_ADDONS).setEnabled(Invaders.getGameState().canBuyAddOns());
        this.getArea(BUY_SHIP_SPEED).setEnabled(Invaders.getGameState().canBuyShipSpeed());
        this.shieldsInstance.setUsed(Invaders.getGameState().getShields());
        this.extraBulletsInstance.setUsed(Invaders.getGameState().getExtraBullets());
        this.gunPowerInstance.setUsed(Invaders.getGameState().getGunPower());
        this.smartBombsInstance.setUsed(Invaders.getGameState().getSmartBombs());
        this.addOnsInstance.setUsed(Invaders.getGameState().getAddOn());
        this.shipSpeedInstance.setUsed(Invaders.getGameState().getShipSpeed());
        if (ShopPrices.SHIELDS[Invaders.getGameState().getShields()] == -1) {
            this.shieldsInstance.setPrice(-1);
        } else {
            this.shieldsInstance.setPrice(ShopPrices.SHIELDS[Invaders.getGameState().getShields()] * (1 + Invaders.getGameState().getLevel() / 100));
        }
        this.extraBulletsInstance.setPrice(ShopPrices.FIRE_RATE[Invaders.getGameState().getExtraBullets()]);
        this.gunPowerInstance.setPrice(ShopPrices.GUN_POWER[Invaders.getGameState().getGunPower()]);
        this.smartBombsInstance.setPrice(Invaders.getGameState().getSmartBombPrice());
        this.addOnsInstance.setPrice(ShopPrices.ADDON[Invaders.getGameState().getAddOn()]);
        this.shipSpeedInstance.setPrice(ShopPrices.SPEED[Invaders.getGameState().getShipSpeed()]);
        this.moneyLabel.setText("$" + nf.format(Invaders.getGameState().getMoney()));
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        this.moneyLabel.render();
        this.shieldsInstance.render();
        this.extraBulletsInstance.render();
        this.gunPowerInstance.render();
        this.smartBombsInstance.render();
        this.addOnsInstance.render();
        this.shipSpeedInstance.render();
    }
}

