/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.util.Util;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.LaserBrain;
import invaders.SFX;
import invaders.behaviours.AlienLaserEffect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.lwjgl.util.Color;

public class LaserBrainFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final int PHASE_WAIT = 0;
    private static final int PHASE_DELAY = 1;
    private static final int PHASE_ZAP = 2;
    private static final float MAX_RANGE = 4.0f;
    private Range range;
    private float width;
    private int delay;
    private int duration;
    private Color color;
    static /* synthetic */ Class class$0;

    public LaserBrainFeature() {
    }

    public LaserBrainFeature(String name) {
        super(name);
    }

    public LaserBrain spawn(Gidrah gidrah) {
        return new LaserBrainInstance(gidrah, this);
    }

    private static class LaserBrainInstance
    implements LaserBrain {
        private static final long serialVersionUID = 1L;
        private final Gidrah gidrah;
        private int tick;
        private int phase;
        private transient LaserBrainFeature feature;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("invaders.LaserBrainFeature");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private LaserBrainInstance(Gidrah gidrah, LaserBrainFeature feature) {
            this.gidrah = gidrah;
            this.feature = feature;
            this.initTick();
        }

        private void initTick() {
            int minMax = (int)this.feature.range.getMin() * 2;
            this.tick = Math.max((int)this.feature.range.getMin(), Util.random((int)((int)this.feature.range.getMin()), (int)Math.max(minMax, (int)this.feature.range.getMax() - Invaders.getGameState().getTotalMultiplier() / 2)));
            int numGidrahs = Gidrah.getGidrahs().size();
            if (numGidrahs == 1) {
                this.tick = (int)((float)this.tick * 0.25f);
            } else if (numGidrahs <= 4) {
                this.tick = (int)((float)this.tick * 0.5f);
            } else if (numGidrahs <= Invaders.getGameState().getMultiplier()) {
                this.tick = (int)((float)this.tick * 0.75f);
            }
            this.phase = 0;
        }

        public void tick() {
            switch (this.phase) {
                case 0: {
                    if (--this.tick > 0) break;
                    this.phase = 1;
                    this.tick = this.feature.delay;
                    SFX.alienLaserPowerup();
                    break;
                }
                case 1: {
                    if (--this.tick <= 0) {
                        this.gidrah.setFlash(false);
                        this.gidrah.setOffset(0, 0);
                        this.fire();
                        break;
                    }
                    int range = (int)SineInterpolator.instance.interpolate(4.0f, 0.0f, (float)this.tick / (float)this.feature.delay);
                    this.gidrah.setFlash((this.tick & 2) == 0);
                    this.gidrah.setOffset(Util.random((int)(-range), (int)range), Util.random((int)(-range), (int)range));
                    break;
                }
                case 2: {
                    if (--this.tick > 0) break;
                    this.initTick();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void fire() {
            this.phase = 2;
            this.tick = this.feature.duration;
            AlienLaserEffect laser = new AlienLaserEffect(this.feature.width, this.feature.color, this.feature.duration, this.gidrah);
            laser.spawn(GameScreen.getInstance());
            SFX.alienLaserFire();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            if (this.feature.getName() != null) {
                stream.writeBoolean(true);
                stream.writeUTF(this.feature.getName());
            } else {
                stream.writeBoolean(false);
                stream.writeObject((Object)this.feature);
            }
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                boolean namedFeature = stream.readBoolean();
                if (namedFeature) {
                    this.feature = (LaserBrainFeature)Resources.get((String)stream.readUTF());
                } else {
                    this.feature = (LaserBrainFeature)((Object)stream.readObject());
                    this.feature.create();
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

