/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import invaders.Background;
import invaders.Entity;
import invaders.Invaders;
import invaders.InvadersGameState;
import invaders.Player;
import invaders.Res;
import invaders.SFX;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.widgets.PowerDisplay;
import net.puppygames.applet.widgets.PowerDisplayFeature;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class GameScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    static final String GAMEOVER = "gameover";
    public static final float FLOOR = 19.0f;
    public static final float CEILING = 80.0f;
    private static GameScreen instance;
    private static final Color cachedColor;
    private static final Rectangle tempRect;
    private static Background background;
    private static InvadersGameState gameState;
    private int scoreX;
    private int scoreY;
    private int scoreWidth;
    private int moneyX;
    private int moneyY;
    private int moneyWidth;
    private int multX;
    private int multY;
    private Rectangle rocketReloadBounds;
    private Rectangle laserReloadBounds;
    private Color rocketReloadColor;
    private Color laserReloadColor;
    private PowerDisplayFeature shieldPower;
    private PowerDisplayFeature smarts;
    private PowerDisplayFeature ammoDisplay;
    private transient GLString scoreLabel;
    private transient GLString moneyLabel;
    private transient GLString multLabel;
    private transient PowerDisplay shieldPowerInstance;
    private transient PowerDisplay smartsInstance;
    private transient Area shieldsEmpty;
    private transient Area laserReload;
    private transient Area rocketReload;
    private transient int rocketTick;
    private transient int rocketTime;
    private transient int laserTick;
    private transient int laserTime;

    static {
        cachedColor = new Color();
        tempRect = new Rectangle();
    }

    public GameScreen(String name) {
        super(name);
    }

    private static void setBackground(Background background) {
        GameScreen.background = background;
        if (background != null) {
            background.init(GameScreen.getInstance());
        }
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    protected void doTick() {
        if (Invaders.isPaused()) {
            return;
        }
        Invaders.onTicked();
        gameState.tick();
        this.shieldPowerInstance.setUsed(Invaders.getGameState().getShields());
        this.smartsInstance.setUsed(Invaders.getGameState().getSmartBombs());
        if (Invaders.getGameState().getShields() == 0 && this.shieldsEmpty != null && !this.shieldsEmpty.isVisible()) {
            this.shieldsEmpty.setVisible(true);
        } else if (this.shieldsEmpty != null && this.shieldsEmpty.isVisible() && Invaders.getGameState().getShields() > 0) {
            this.shieldsEmpty.setVisible(false);
        }
        if (Invaders.getGameState().getAddOn() >= 3 && !this.rocketReload.isVisible()) {
            this.rocketReload.setVisible(true);
        }
        if (Invaders.getGameState().getAddOn() == 4 && !this.laserReload.isVisible()) {
            this.laserReload.setVisible(true);
        }
    }

    protected void doCleanup() {
        if (background != null) {
            background.cleanup();
            background = null;
        }
        this.shieldPowerInstance.cleanup();
        this.smartsInstance.cleanup();
        this.shieldPowerInstance = null;
        this.smartsInstance = null;
        Mouse.setGrabbed((boolean)false);
    }

    protected void onOpen() {
        this.shieldPowerInstance = this.shieldPower.spawn((Screen)this);
        this.smartsInstance = this.smarts.spawn((Screen)this);
        this.rocketReload.setVisible(false);
        this.laserReload.setVisible(false);
        Mouse.setGrabbed((boolean)true);
    }

    public static int getTick() {
        return gameState.getTick();
    }

    public static int getTotalTicks() {
        int oldTotalTicks = gameState.getTotalTicks();
        gameState.resetTotalTicks();
        return oldTotalTicks;
    }

    public static void beginLevel() {
        instance.open();
        SFX.gameMusic(gameState.getLevel());
        GameScreen.setBackground(gameState.getCurrentLevel().getBackground());
    }

    public static void beginGame(InvadersGameState gameState) {
        GameScreen.gameState = gameState;
        instance.setVisible(GAMEOVER, false);
        instance.open();
    }

    public static void gameOver() {
        LabelEffect gameOverEffect = new LabelEffect(Res.getBigFont(), "Game Over", Color.WHITE, Color.RED, 320, 120);
        gameOverEffect.setLocation((float)(Invaders.getWidth() / 2), (float)(Invaders.getHeight() / 2));
        gameOverEffect.setVisible(true);
        gameOverEffect.spawn((Screen)instance);
        Invaders.playMusic(null, (int)180);
        instance.setVisible(GAMEOVER, true);
    }

    protected void doCreateScreen() {
        this.scoreLabel = new GLString(16);
        this.scoreLabel.setLocation(this.scoreX, this.scoreY);
        this.scoreLabel.setFont(Res.getSmallFont());
        this.moneyLabel = new GLString(16);
        this.moneyLabel.setLocation(this.moneyX, this.moneyY);
        this.moneyLabel.setFont(Res.getSmallFont());
        this.multLabel = new GLString(2);
        this.multLabel.setLocation(this.multX, this.multY);
        this.multLabel.setFont(Res.getSmallFont());
        this.shieldsEmpty = this.getArea("shields_empty");
        this.rocketReload = this.getArea("rocketreload");
        this.laserReload = this.getArea("laserreload");
        this.setDefaultScreen();
    }

    protected void postRender() {
        int width;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        if (Invaders.getGameState().getAddOn() >= 3) {
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            width = (int)LinearInterpolator.instance.interpolate(0.0f, (float)this.rocketReloadBounds.getWidth(), (float)this.rocketTick / (float)this.rocketTime);
            ColorUtil.setGLColor((ReadableColor)this.rocketReloadColor);
            GL11.glVertex2i((int)this.rocketReloadBounds.getX(), (int)this.rocketReloadBounds.getY());
            GL11.glVertex2i((int)(this.rocketReloadBounds.getX() + width), (int)this.rocketReloadBounds.getY());
            GL11.glVertex2i((int)(this.rocketReloadBounds.getX() + width), (int)(this.rocketReloadBounds.getY() + this.rocketReloadBounds.getHeight()));
            GL11.glVertex2i((int)this.rocketReloadBounds.getX(), (int)(this.rocketReloadBounds.getY() + this.rocketReloadBounds.getHeight()));
            GL11.glEnd();
        }
        if (Invaders.getGameState().getAddOn() == 4) {
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            width = (int)LinearInterpolator.instance.interpolate(0.0f, (float)this.laserReloadBounds.getWidth(), (float)this.laserTick / (float)this.laserTime);
            ColorUtil.setGLColor((ReadableColor)this.laserReloadColor);
            GL11.glVertex2i((int)this.laserReloadBounds.getX(), (int)this.laserReloadBounds.getY());
            GL11.glVertex2i((int)(this.laserReloadBounds.getX() + width), (int)this.laserReloadBounds.getY());
            GL11.glVertex2i((int)(this.laserReloadBounds.getX() + width), (int)(this.laserReloadBounds.getY() + this.laserReloadBounds.getHeight()));
            GL11.glVertex2i((int)this.laserReloadBounds.getX(), (int)(this.laserReloadBounds.getY() + this.laserReloadBounds.getHeight()));
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        ColorUtil.setGLColor((ReadableColor)Color.WHITE);
        this.scoreLabel.setText(String.valueOf(Invaders.getGameState().getScore()));
        this.moneyLabel.setText(String.valueOf(Invaders.getGameState().getMoney()));
        this.scoreLabel.setLocation(this.scoreX + this.scoreWidth - this.scoreLabel.getBounds(tempRect).getWidth(), this.scoreY);
        this.scoreLabel.render();
        this.moneyLabel.setLocation(this.moneyX + this.moneyWidth - this.moneyLabel.getBounds(tempRect).getWidth(), this.moneyY);
        this.moneyLabel.render();
        int mult = Invaders.getGameState().getMultiplier();
        if (mult > 1) {
            this.multLabel.setText(String.valueOf(mult));
            this.multLabel.render();
        }
    }

    public static Player getPlayer() {
        return gameState.getPlayer();
    }

    public static void addEntity(Entity entity) {
        instance.addTickable(entity);
        gameState.addEntity(entity);
    }

    public static GameScreen getInstance() {
        return instance;
    }

    public static void onExit() {
        if (instance != null && instance.isOpen()) {
            Game.saveGame();
        }
    }

    public static AnimatedAppearance getSaucerAppearance() {
        return background.getSaucerAppearance();
    }

    public static void setLaserReload(int tick, int time) {
        GameScreen.instance.laserTick = tick;
        GameScreen.instance.laserTime = time;
    }

    public static void setRocketReload(int tick, int time) {
        GameScreen.instance.rocketTick = tick;
        GameScreen.instance.rocketTime = time;
    }
}

