/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.util.XMLUtil;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.LaserBrain;
import invaders.LaserBrainFeature;
import invaders.ShootBrain;
import invaders.ShootBrainFeature;
import invaders.Turret;
import invaders.TurretFeature;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.puppygames.applet.effects.EmitterFeature;
import org.w3c.dom.Element;

public abstract class Behaviour
extends Feature {
    private static final long serialVersionUID = 1L;
    public static final Behaviour BLANK = new Behaviour("gidrah.blank"){
        private static final long serialVersionUID = 1L;

        protected Instance createInstance(Gidrah gidrah) {
            return null;
        }

        public void deathNoise() {
        }
    };
    private static final List BEHAVIOURS = new LinkedList();
    private String appearance;
    private float radius;
    private float gap;
    private int hitPoints;
    private String explosion;
    private String ricochet;
    private ShootBrainFeature shootBrain;
    private LaserBrainFeature laserBrain;
    private Behaviour slave;
    private boolean isSlave;
    private int numSlaves;
    private int splitChance;
    private int points;
    private boolean boss;
    private List turretFeatures;
    private String sound;
    private transient AnimatedAppearanceResource appearanceResource;
    private transient EmitterFeature explosionEmitterFeature;
    private transient EmitterFeature ricochetEmitterFeature;
    private transient ALBuffer soundResource;

    public Behaviour(String name) {
        super(name);
    }

    protected void doCreate() {
        super.doCreate();
        if (this.gap == 0.0f) {
            this.gap = this.radius;
        }
        Iterator i = this.turretFeatures.iterator();
        while (i.hasNext()) {
            ((TurretFeature)((Object)i.next())).create();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        Iterator i = this.turretFeatures.iterator();
        while (i.hasNext()) {
            ((TurretFeature)((Object)i.next())).destroy();
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List children = XMLUtil.getChildren((Element)element, (String)"turret");
        this.turretFeatures = new LinkedList();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            TurretFeature tf = new TurretFeature();
            tf.load(child, loader);
            this.turretFeatures.add(tf);
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public final Instance init(Gidrah gidrah, int row) {
        gidrah.setAppearance((AnimatedAppearance)this.appearanceResource);
        Instance ret = this.createInstance(gidrah);
        if (this.shootBrain != null) {
            ret.shootBrain = this.shootBrain.spawn(gidrah);
        }
        if (this.laserBrain != null) {
            ret.laserBrain = this.laserBrain.spawn(gidrah);
        }
        if (this.soundResource != null) {
            gidrah.setSound(this.soundResource);
        }
        return ret;
    }

    public final void reinit(Gidrah gidrah) {
        if (this.soundResource != null) {
            gidrah.setSound(this.soundResource);
        }
    }

    protected abstract Instance createInstance(Gidrah var1);

    public EmitterFeature getExplosionEmitter() {
        return this.explosionEmitterFeature;
    }

    public EmitterFeature getRicochetEmitter() {
        return this.ricochetEmitterFeature;
    }

    public int getPoints() {
        return this.points;
    }

    public float getGap() {
        return this.gap;
    }

    public boolean isBoss() {
        return this.boss;
    }

    public ALBuffer getSound() {
        return this.soundResource;
    }

    protected void doRegister() {
        super.doRegister();
        BEHAVIOURS.add(this);
    }

    protected void doDeregister() {
        super.doDeregister();
        BEHAVIOURS.remove((Object)this);
    }

    public static void onNewLevel() {
        Iterator i = BEHAVIOURS.iterator();
        while (i.hasNext()) {
            ((Behaviour)((Object)i.next())).doOnNewLevel();
        }
    }

    protected void doOnNewLevel() {
    }

    public abstract void deathNoise();

    protected static abstract class Instance
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Gidrah gidrah;
        private Gidrah master;
        private transient ShootBrain shootBrain;
        private transient LaserBrain laserBrain;
        private double angle;
        private Turret[] turret;

        public Instance(Gidrah gidrah) {
            int numTurrets;
            this.gidrah = gidrah;
            if (gidrah.getMaster() != null) {
                this.setMaster(gidrah.getMaster());
            }
            if (gidrah.getBehaviour().slave != null) {
                Behaviour slaveBehaviour = gidrah.getBehaviour().slave;
                try {
                    int i = 0;
                    while (i < gidrah.getBehaviour().numSlaves) {
                        Gidrah g = new Gidrah(slaveBehaviour, gidrah.getInitialRow());
                        g.setMaster(gidrah);
                        g.spawn(GameScreen.getInstance());
                        double angle = (double)i / (double)gidrah.getBehaviour().numSlaves * 360.0;
                        g.getBehaviourInstance().setAngle(angle);
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            if ((numTurrets = gidrah.getBehaviour().turretFeatures.size()) > 0) {
                this.turret = new Turret[numTurrets];
                int count = 0;
                Iterator i = gidrah.getBehaviour().turretFeatures.iterator();
                while (i.hasNext()) {
                    TurretFeature tf = (TurretFeature)((Object)i.next());
                    this.turret[count++] = tf.spawn(gidrah);
                }
            }
        }

        public boolean canCollide() {
            return true;
        }

        public void init() {
        }

        public abstract float getVX();

        public final void setAngle(double angle) {
            this.angle = angle;
        }

        public final double getAngle() {
            return this.angle;
        }

        private final void setMaster(Gidrah master) {
            this.master = master;
        }

        public final Gidrah getMaster() {
            return this.master;
        }

        public final Gidrah getGidrah() {
            return this.gidrah;
        }

        public final void tick() {
            if (this.master != null && this.master.isActive() && this.master.isCritical() && !this.gidrah.isCritical()) {
                this.gidrah.criticalHit();
                return;
            }
            this.doTick();
            if (this.gidrah.isActive()) {
                if (this.gidrah.getBehaviourInstance().shootBrain != null) {
                    this.gidrah.getBehaviourInstance().shootBrain.tick();
                }
                if (this.gidrah.getBehaviourInstance().laserBrain != null) {
                    this.gidrah.getBehaviourInstance().laserBrain.tick();
                }
            }
        }

        protected abstract void doTick();

        public final void onKilled() {
            if (this.turret != null) {
                int i = 0;
                while (i < this.turret.length) {
                    this.turret[i].kill();
                    ++i;
                }
                this.turret = null;
            }
            this.doOnKilled();
        }

        protected void doOnKilled() {
        }

        public void onDamaged() {
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            if (this.shootBrain != null) {
                stream.writeBoolean(true);
                stream.writeObject(this.shootBrain);
            } else {
                stream.writeBoolean(false);
            }
            if (this.laserBrain != null) {
                stream.writeBoolean(true);
                stream.writeObject(this.laserBrain);
            } else {
                stream.writeBoolean(false);
            }
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                boolean hasLaser;
                boolean hasShooter = stream.readBoolean();
                if (hasShooter) {
                    this.shootBrain = (ShootBrain)stream.readObject();
                }
                if (hasLaser = stream.readBoolean()) {
                    this.laserBrain = (LaserBrain)stream.readObject();
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        protected void onRemove() {
        }
    }
}

