/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.Background;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class MessageBox {
    private final Rectangle bounds = new Rectangle();
    private final GLTextArea title = new GLTextArea();
    private final GLTextArea message = new GLTextArea();
    private final Background.Instance titleBackground;
    private final Background.Instance background;
    private static final int MARGIN = 8;

    public MessageBox() {
        this.title.setFont(Res.getBigFont());
        this.title.setHorizontalAlignment(TextLayout.CENTERED);
        this.title.setVerticalAlignment(GLTextArea.TOP);
        this.titleBackground = Res.getMessageTitleBackground().spawn();
        this.message.setFont(Res.getSmallFont());
        this.message.setVerticalAlignment(GLTextArea.TOP);
        this.background = Res.getMessageBodyBackground().spawn();
    }

    public void setSize(int width, int height) {
        this.bounds.setSize(width, height);
        this.bounds.setLocation((Game.getWidth() - width) / 2, (Game.getHeight() - height) / 2);
        int titleHeight = this.title.getFont().getHeight() + 16;
        this.title.setBounds(8, height - 16 - titleHeight, width - 16, titleHeight);
        this.message.setBounds(8, this.title.getY() - 8 - titleHeight, width - 16, height - this.title.getY() - 16);
        this.titleBackground.setBounds((ReadableRectangle)new Rectangle(0, 0, this.title.getWidth(), this.title.getHeight()));
        this.background.setBounds((ReadableRectangle)new Rectangle(0, 0, width, height));
    }

    public void setTitle(String titleText) {
        this.title.setText(titleText);
    }

    public void setMessage(String messageText) {
        this.message.setText(messageText);
    }

    public void render(SimpleRenderer renderer) {
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)MessageBox.this.bounds.getX(), (float)MessageBox.this.bounds.getY(), (float)0.0f);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            }
        });
        this.background.render(renderer);
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)MessageBox.this.title.getX(), (float)(MessageBox.this.title.getY() + MessageBox.this.title.getFont().getDescent()), (float)0.0f);
            }
        });
        this.titleBackground.render(renderer);
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            }
        });
        this.title.render(renderer);
        this.message.render(renderer);
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glPopMatrix();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        });
        this.title.render(renderer);
        this.message.render(renderer);
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glPopMatrix();
            }
        });
    }
}

