/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.PlayerSlot;
import net.puppygames.applet.Res;
import net.puppygames.applet.screens.DialogScreen;
import net.puppygames.applet.screens.EnterNameDialog;
import net.puppygames.applet.screens.SlotEffect;
import net.puppygames.applet.screens.SlotEffectListener;

public class SlotScreen
extends DialogScreen
implements SlotEffectListener {
    private static SlotScreen instance;
    private static final int maxSlots = 6;
    private static final String ID_NEW = "new";
    private static final String ID_DELETE = "delete";
    private static final String ID_RENAME = "rename";
    private static final String DELETE_TITLE = "DELETE PROFILE";
    private static final String DELETE_MESSAGE = "THIS ACTION CANNOT BE UNDONE. ARE YOU SURE YOU WANT TO DELETE ";
    private static final String ID_SLOT_ORIGIN = "slot_origin";
    private String slotClass;
    private int gap;
    private transient List slots;
    private transient Class slotClazz;
    private transient int selectedIndex;
    private transient Area slotOriginArea;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.screens.SlotScreen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SlotScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        if (!$assertionsDisabled && instance != null) {
            throw new AssertionError();
        }
        instance = this;
    }

    protected void doDeregister() {
        if (!$assertionsDisabled && instance != this) {
            throw new AssertionError();
        }
        instance = null;
    }

    public static void show() {
        if (!instance.isCreated()) {
            instance.create();
        }
        instance.open();
    }

    protected void doCreateScreen() {
        try {
            this.slotClazz = Class.forName(this.slotClass);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.slotOriginArea = this.getArea(ID_SLOT_ORIGIN);
    }

    protected void doOnOpen() {
        this.rebuild();
    }

    private void rebuild() {
        SlotEffect se;
        if (this.slots != null) {
            Iterator i = this.slots.iterator();
            while (i.hasNext()) {
                SlotEffect se2 = (SlotEffect)i.next();
                se2.remove();
            }
            this.slots = null;
        }
        List playerSlots = PlayerSlot.getSlots();
        this.slots = new ArrayList(playerSlots.size());
        int y = this.slotOriginArea.getBounds().getY();
        Iterator i = playerSlots.iterator();
        while (i.hasNext()) {
            PlayerSlot ps = (PlayerSlot)i.next();
            try {
                se = (SlotEffect)this.slotClazz.newInstance();
                se.setSlot(ps);
                se.setLocation(this.slotOriginArea.getBounds().getX(), y);
                se.spawn(this);
                se.setSlotEffectListener(this);
                if (ps.equals(Game.getPlayerSlot())) {
                    se.setSelected(true);
                }
                this.slots.add(se);
                y -= this.gap;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        this.selectedIndex = -2;
        int idx = -1;
        Iterator i2 = this.slots.iterator();
        while (i2.hasNext()) {
            se = (SlotEffect)i2.next();
            ++idx;
            if (se.isSelected()) break;
        }
        this.setSelectedIndex(idx);
    }

    protected void onClicked(String id) {
        if (ID_NEW.equals(id)) {
            EnterNameDialog.show(true, new Runnable(){

                public void run() {
                    if (EnterNameDialog.isOKClicked()) {
                        SlotScreen.this.close();
                    }
                }
            });
        } else if (ID_DELETE.equals(id)) {
            this.deleteSelected();
        } else if (ID_RENAME.equals(id)) {
            this.renameSelected();
        } else if ("cancel".equals(id) && this.selectedIndex != -1) {
            SlotEffect se = (SlotEffect)this.slots.get(this.selectedIndex);
            Game.setPlayerSlot(se.getSlot());
            this.close();
        }
    }

    protected void deleteSelected() {
        if (this.selectedIndex == -1) {
            return;
        }
        final SlotEffect se = (SlotEffect)this.slots.get(this.selectedIndex);
        Res.getDeleteYesCancelDialog().doModal(DELETE_TITLE, "THIS ACTION CANNOT BE UNDONE. ARE YOU SURE YOU WANT TO DELETE '" + se.getSlot().getName().toUpperCase() + "'?", new Runnable(){

            public void run() {
                int option = Res.getDeleteYesCancelDialog().getOption();
                if (option == 0 || option == 2) {
                    se.getSlot().delete();
                    if (SlotScreen.this.selectedIndex == SlotScreen.this.slots.size() - 1) {
                        SlotScreen slotScreen = SlotScreen.this;
                        slotScreen.selectedIndex = slotScreen.selectedIndex - 1;
                    }
                    if (SlotScreen.this.selectedIndex == -1) {
                        Game.setPlayerSlot(null);
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    } else {
                        Game.setPlayerSlot(((SlotEffect)SlotScreen.this.slots.get(SlotScreen.this.selectedIndex)).getSlot());
                    }
                    SlotScreen.this.rebuild();
                }
            }
        });
    }

    protected void renameSelected() {
    }

    protected void doCleanup() {
        this.slots = null;
    }

    public void onSlotEffectChanged(SlotEffect effect) {
        if (effect.isSelected()) {
            this.setSelectedIndex(this.slots.indexOf(effect));
            Iterator i = this.slots.iterator();
            while (i.hasNext()) {
                SlotEffect se = (SlotEffect)i.next();
                if (se == effect) continue;
                se.setSelected(false);
            }
        }
    }

    public void onSlotEffectEdited(SlotEffect effect) {
    }

    public void setSelectedIndex(int newIndex) {
        if (this.selectedIndex != newIndex) {
            this.selectedIndex = newIndex;
            this.enableControls();
        }
    }

    protected void enableControls() {
        this.setEnabled(ID_NEW, this.slots.size() < 6);
        this.setEnabled(ID_DELETE, this.selectedIndex != -1 && this.slots.size() > 1);
        this.setEnabled(ID_RENAME, this.selectedIndex != -1);
        this.setEnabled("cancel", this.selectedIndex != -1 || this.selectedIndex == -1 && Game.getPlayerSlot() != null && Game.getPlayerSlot().exists());
    }
}

