/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import net.puppygames.applet.Screen;

public class DialogScreen
extends Screen {
    protected static final String OK = "ok";
    protected static final String CANCEL = "cancel";
    protected static final String YES = "yes";
    protected static final String NO = "no";
    protected static final String TITLE = "title";
    protected static final String MESSAGE = "message";
    public static final int NONE = -1;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int YES_OPTION = 2;
    public static final int NO_OPTION = 3;
    private transient int option;
    private transient Runnable callback;

    public DialogScreen(String name) {
        super(name);
    }

    protected final void onOpen() {
        this.option = -1;
        this.doOnOpen();
    }

    protected void doOnOpen() {
    }

    public void doModal(String title, String message, Runnable callback) {
        if (this.getArea(TITLE) != null && title != null) {
            this.getArea(TITLE).setText(title);
        }
        if (this.getArea(MESSAGE) != null && message != null) {
            this.getArea(MESSAGE).setText(message);
        }
        this.callback = callback;
        this.open();
    }

    protected final void onClose() {
        if (this.callback != null) {
            this.callback.run();
            this.callback = null;
        }
        this.doOnClose();
    }

    protected void doOnClose() {
    }

    public int getOption() {
        return this.option;
    }

    protected void onClicked(String id) {
        if (OK.equals(id)) {
            this.option = 0;
            this.close();
        }
        if (CANCEL.equals(id)) {
            this.option = 1;
            this.close();
        }
        if (YES.equals(id)) {
            this.option = 2;
            this.close();
        }
        if (NO.equals(id)) {
            this.option = 3;
            this.close();
        }
    }
}

