/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.resources.Feature;
import net.puppygames.applet.Bounded;
import net.puppygames.applet.Game;
import org.lwjgl.util.ReadableRectangle;

public class Anchor
extends Feature {
    private String x;
    private String y;
    private String w;
    private String h;
    private int d;

    public void apply(Bounded target) {
        ReadableRectangle bounds = target.getBounds();
        int newX = bounds.getX();
        int newY = bounds.getY();
        int newW = bounds.getWidth();
        int newH = bounds.getHeight();
        if (this.x != null) {
            newX = this.position(this.x, true);
        }
        if (this.y != null) {
            newY = this.position(this.y, false);
        }
        if (this.w != null) {
            newW = this.position(this.w, true) - newX;
        }
        if (this.h != null) {
            newH = this.position(this.h, false) - newY;
        }
        target.setBounds(newX, newY, newW, newH);
    }

    private int position(String edge, boolean horiz) {
        float ratio = 0.0f;
        if ("top".equals(edge) && !horiz) {
            ratio = 1.0f;
        } else if ("bottom".equals(edge) && !horiz) {
            ratio = 0.0f;
        } else if ("left".equals(edge) && horiz) {
            ratio = 0.0f;
        } else if ("right".equals(edge) && horiz) {
            ratio = 1.0f;
        } else if ("mid".equals(edge)) {
            ratio = 0.5f;
        } else if (edge.endsWith("%")) {
            ratio = Float.parseFloat(edge.substring(0, edge.length() - 2)) / 100.0f;
        } else {
            System.out.println("Illegal anchor specified: " + edge + "/" + this.d);
            ratio = 0.0f;
        }
        if (horiz) {
            return (int)((float)Game.getWidth() * ratio) + this.d;
        }
        return (int)((float)Game.getHeight() * ratio) + this.d;
    }
}

