/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.WeakHashMap;
import org.lwjgl.opengl.AMDDebugOutputCallback;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GlobalLock;

final class AMDDebugOutputUtil {
    private static final Map handlers = new WeakHashMap();

    private AMDDebugOutputUtil() {
    }

    public static void registerHandler(AMDDebugOutputCallback.Handler handler) {
        Context ctx = Context.getCurrentContext();
        if (ctx == null) {
            throw new IllegalStateException("No context is current.");
        }
        if (!ctx.getContextAttribs().isDebug()) {
            throw new IllegalStateException("The current context is not a debug context.");
        }
        if (!GLContext.getCapabilities().GL_AMD_debug_output) {
            throw new IllegalStateException("AMD_debug_output is not supported.");
        }
        handlers.put(ctx, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void messageCallback(int id, int category, int severity, String message, ByteBuffer userParam) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            Context ctx = Context.getCurrentContext();
            if (ctx == null) {
                return;
            }
            AMDDebugOutputCallback.Handler handler = (AMDDebugOutputCallback.Handler)handlers.get(ctx);
            if (handler != null) {
                handler.handleMessage(id, category, severity, message);
            }
        }
    }
}

