/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.resources.ColorParser;
import com.shavenpuppy.jglib.resources.DimensionParser;
import com.shavenpuppy.jglib.resources.PointParser;
import com.shavenpuppy.jglib.resources.RectangleParser;
import com.shavenpuppy.jglib.resources.Vector3fParser;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Parseable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XMLUtil {
    private static final Map vars;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.util.XMLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        vars = new HashMap();
    }

    private XMLUtil() {
    }

    public static void putVar(String key, String value) {
        vars.put(key, value);
    }

    private static String decode(String in) throws Exception {
        if (in != null && in.length() > 1 && in.charAt(0) == '$') {
            String key = in.substring(1);
            String val = (String)vars.get(key);
            if (val == null) {
                throw new Exception("Unknown variable " + in);
            }
            return val;
        }
        return in;
    }

    public static String parse(String in) throws Exception {
        if (in.length() < 2 || in.charAt(0) != '=') {
            return in;
        }
        StringBuffer ret = new StringBuffer(in.length() * 2);
        StringTokenizer st = new StringTokenizer(in.substring(1), ",");
        while (st.hasMoreTokens()) {
            String subElement = st.nextToken();
            StringTokenizer bits = new StringTokenizer(subElement, "+-*/&", true);
            StringBuffer sb = new StringBuffer(subElement.length() * 2);
            int lastOperator = 0;
            boolean negate = false;
            while (bits.hasMoreElements()) {
                String token = bits.nextToken();
                while (token.equals("-")) {
                    boolean bl = negate = !negate;
                    if (!bits.hasMoreTokens()) {
                        throw new Exception("Expected operator or value");
                    }
                    token = bits.nextToken();
                }
                String bit = XMLUtil.decode(token);
                switch (lastOperator) {
                    case 0: {
                        sb.append(bit);
                        break;
                    }
                    case 38: {
                        sb.append(bit);
                        break;
                    }
                    case 43: {
                        int left = Integer.parseInt(sb.toString());
                        int right = Integer.parseInt(bit);
                        if (negate) {
                            left = -left;
                            negate = false;
                        }
                        sb.setLength(0);
                        sb.append(left + right);
                        break;
                    }
                    case 45: {
                        int left = Integer.parseInt(sb.toString());
                        int right = Integer.parseInt(bit);
                        if (negate) {
                            left = -left;
                            negate = false;
                        }
                        sb.setLength(0);
                        sb.append(left - right);
                        break;
                    }
                    case 42: {
                        int left = Integer.parseInt(sb.toString());
                        int right = Integer.parseInt(bit);
                        if (negate) {
                            left = -left;
                            negate = false;
                        }
                        sb.setLength(0);
                        sb.append(left * right);
                        break;
                    }
                    case 47: {
                        int left = Integer.parseInt(sb.toString());
                        int right = Integer.parseInt(bit);
                        if (negate) {
                            left = -left;
                            negate = false;
                        }
                        sb.setLength(0);
                        sb.append(left / right);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                if (!bits.hasMoreTokens()) continue;
                String op = bits.nextToken();
                if (op.equals("+") || op.equals("-") || op.equals("*") || op.equals("/") || op.equals("&")) {
                    lastOperator = op.charAt(0);
                    continue;
                }
                throw new Exception("Expected + - / * or & operator");
            }
            ret.append(sb.toString());
            if (!st.hasMoreTokens()) continue;
            ret.append(',');
        }
        return ret.toString();
    }

    public static boolean hasAttribute(Element element, String attribute) {
        String s = element.getAttribute(attribute);
        return s != null && !"".equals(s);
    }

    public static boolean hasChild(Element element, String child) throws Exception {
        NodeList nodes = element.getChildNodes();
        Element ret = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equals(child) && childNode.getNodeType() == 1) {
                if (ret != null) {
                    throw new Exception("Child element '" + child + "' present multiple times");
                }
                ret = (Element)childNode;
            }
            ++i;
        }
        return ret != null;
    }

    public static Element getChild(Element element, String child) throws Exception {
        NodeList nodes = element.getChildNodes();
        Element ret = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equalsIgnoreCase(child) && childNode.getNodeType() == 1) {
                if (ret != null) {
                    throw new Exception("Child element '" + child + "' present multiple times");
                }
                ret = (Element)childNode;
            }
            ++i;
        }
        if (ret == null) {
            return null;
        }
        return ret;
    }

    public static Element getFirstChild(Element element, String child) throws Exception {
        NodeList nodes = element.getChildNodes();
        Element ret = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equalsIgnoreCase(child) && childNode.getNodeType() == 1) {
                ret = (Element)childNode;
                return ret;
            }
            ++i;
        }
        return null;
    }

    public static List getChildren(Element element, String name) throws Exception {
        NodeList nodes = element.getChildNodes();
        ArrayList<Node> ret = new ArrayList<Node>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equals(name) && childNode.getNodeType() == 1) {
                ret.add(childNode);
            }
            ++i;
        }
        return ret;
    }

    public static List getChildren(Element element) throws Exception {
        NodeList nodes = element.getChildNodes();
        ArrayList<Node> ret = new ArrayList<Node>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeType() == 1) {
                ret.add(childNode);
            }
            ++i;
        }
        return ret;
    }

    public static boolean getBoolean(Element element, String attribute) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return Boolean.valueOf(s);
    }

    public static boolean getOptionalBoolean(Element element, String attribute, boolean defaultValue) {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static boolean getBoolean(Element element, String attribute, boolean defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static float getFloat(Element element, String attribute) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return Float.parseFloat(s);
    }

    public static float getFloat(Element element, String attribute, float defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    public static int getInt(Element element, String attribute) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Integer.parseInt(s);
    }

    public static int getOptionalInt(Element element, String attribute, int defaultValue) {
        if (element.hasAttribute(attribute)) {
            String s = element.getAttribute(attribute);
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            return Integer.parseInt(s);
        }
        return defaultValue;
    }

    public static int getInt(Element element, String attribute, int defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static String getString(Element element, String attribute) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return s;
    }

    public static String getString(Element element, String attribute, String defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return s;
    }

    public static String getText(Element element, String defaultText) throws Exception {
        NodeList children = element.getChildNodes();
        String ret = defaultText;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Text) {
                Text text = (Text)child;
                ret = text.getData().trim();
                ret = ret.replaceAll("\\\\n", "\n");
                ret = ret.replaceAll("\\\\t", "\t");
                return ret;
            }
            ++i;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void grabXMLAttributes(Resource.Loader loader, Object destination, Class root, Element element) throws Exception {
        Class<?> clazz = destination.getClass();
        while (root.isAssignableFrom(clazz)) {
            Field[] fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                fields[i].setAccessible(true);
                if (!(Modifier.isFinal(fields[i].getModifiers()) || Modifier.isStatic(fields[i].getModifiers()) || Modifier.isTransient(fields[i].getModifiers()))) {
                    String attribute = XMLUtil.getString(element, fields[i].getName(), null);
                    if (attribute == null) {
                        attribute = XMLUtil.getString(element, fields[i].getName().toLowerCase(), null);
                    }
                    if (attribute == null) {
                        List childrenOfChild;
                        Element child;
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("com.shavenpuppy.jglib.Resource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz2.isAssignableFrom(fields[i].getType()) && (child = XMLUtil.getChild(element, fields[i].getName().toLowerCase())) != null && (childrenOfChild = XMLUtil.getChildren(child)).size() != 0 && childrenOfChild.size() == 1) {
                            Resource oldResource = (Resource)fields[i].get(destination);
                            if (oldResource != null) {
                                if (oldResource.isCreated()) {
                                    oldResource.destroy();
                                }
                                fields[i].set(destination, null);
                            }
                            Resource resource = loader.load((Element)childrenOfChild.get(0));
                            if (!fields[i].getType().isAssignableFrom(resource.getClass())) throw new Exception("Child resource " + resource + " not compatible with field " + fields[i].getName() + " of " + destination);
                            fields[i].set(destination, resource);
                        }
                    } else if (fields[i].getType().equals(Integer.TYPE)) {
                        if (attribute.endsWith("fp")) {
                            fields[i].setInt(destination, FPMath.parse(attribute));
                        } else {
                            fields[i].setInt(destination, Integer.parseInt(attribute));
                        }
                    } else if (fields[i].getType().equals(Short.TYPE)) {
                        fields[i].setShort(destination, Short.parseShort(attribute));
                    } else if (fields[i].getType().equals(Byte.TYPE)) {
                        fields[i].setByte(destination, Byte.parseByte(attribute));
                    } else {
                        Class<?> clazz3 = fields[i].getType();
                        Class<?> clazz4 = class$2;
                        if (clazz4 == null) {
                            try {
                                clazz4 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz3.equals(clazz4)) {
                            fields[i].set(destination, attribute);
                        } else if (fields[i].getType().equals(Float.TYPE)) {
                            fields[i].setFloat(destination, Float.parseFloat(attribute));
                        } else if (fields[i].getType().equals(Double.TYPE)) {
                            fields[i].setDouble(destination, Double.parseDouble(attribute));
                        } else if (fields[i].getType().equals(Character.TYPE)) {
                            fields[i].setChar(destination, attribute.charAt(0));
                        } else if (fields[i].getType().equals(Boolean.TYPE)) {
                            fields[i].setBoolean(destination, Boolean.valueOf(attribute));
                        } else {
                            Class<?> clazz5 = fields[i].getType();
                            Class<?> clazz6 = class$3;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = Class.forName("org.lwjgl.util.Rectangle");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz5 == clazz6) {
                                fields[i].set(destination, RectangleParser.parse(attribute));
                            } else {
                                Class<?> clazz7 = fields[i].getType();
                                Class<?> clazz8 = class$4;
                                if (clazz8 == null) {
                                    try {
                                        clazz8 = Class.forName("org.lwjgl.util.Point");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz7 == clazz8) {
                                    fields[i].set(destination, PointParser.parse(attribute));
                                } else {
                                    Class<?> clazz9 = fields[i].getType();
                                    Class<?> clazz10 = class$5;
                                    if (clazz10 == null) {
                                        try {
                                            clazz10 = Class.forName("org.lwjgl.util.vector.Vector3f");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz9 == clazz10) {
                                        fields[i].set(destination, Vector3fParser.parse(attribute));
                                    } else {
                                        Class<?> clazz11 = fields[i].getType();
                                        Class<?> clazz12 = class$6;
                                        if (clazz12 == null) {
                                            try {
                                                clazz12 = Class.forName("org.lwjgl.util.Dimension");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz11 == clazz12) {
                                            fields[i].set(destination, DimensionParser.parse(attribute));
                                        } else {
                                            Class<?> clazz13 = fields[i].getType();
                                            Class<?> clazz14 = class$7;
                                            if (clazz14 == null) {
                                                try {
                                                    clazz14 = Class.forName("org.lwjgl.util.Color");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz13 == clazz14) {
                                                fields[i].set(destination, ColorParser.parse(attribute));
                                            } else {
                                                Class<?> clazz15 = class$8;
                                                if (clazz15 == null) {
                                                    try {
                                                        clazz15 = Class.forName("com.shavenpuppy.jglib.util.Decodeable");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz15.isAssignableFrom(fields[i].getType())) {
                                                    Class<?> clazz16 = fields[i].getType();
                                                    Class[] classArray = new Class[1];
                                                    Class<?> clazz17 = class$2;
                                                    if (clazz17 == null) {
                                                        try {
                                                            clazz17 = Class.forName("java.lang.String");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    classArray[0] = clazz17;
                                                    Method decodeMethod = clazz16.getDeclaredMethod("decode", classArray);
                                                    fields[i].set(destination, decodeMethod.invoke(fields[i].getType(), attribute));
                                                } else {
                                                    Class<?> clazz18 = class$9;
                                                    if (clazz18 == null) {
                                                        try {
                                                            clazz18 = Class.forName("com.shavenpuppy.jglib.util.Parseable");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz18.isAssignableFrom(fields[i].getType())) {
                                                        Parseable parseable = (Parseable)fields[i].getType().newInstance();
                                                        parseable.fromString(attribute);
                                                        fields[i].set(destination, parseable);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadChildResources(Resource resource, Element resourceElement, Resource.Loader loader) throws Exception {
        Class<?> clazz;
        Class<?> clazz2 = resource.getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Field[] fields = clazz2.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Object value;
                    Field f = fields[i];
                    f.setAccessible(true);
                    if (!(Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || (value = f.get(resource)) != null)) {
                        Element childElement;
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("com.shavenpuppy.jglib.Resource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz3.isAssignableFrom(f.getType()) && (childElement = XMLUtil.getFirstChild(resourceElement, f.getName())) != null) {
                            Resource newResource = (Resource)f.getType().newInstance();
                            newResource.load(childElement, loader);
                            f.set(resource, newResource);
                        }
                    }
                    ++i;
                }
                clazz2 = clazz2.getSuperclass();
            }
            if ((clazz = class$1) != null) continue;
            try {
                clazz = Class.forName("com.shavenpuppy.jglib.Resource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(clazz2));
        XMLUtil.getChildren(resourceElement);
    }

    public static float getNormalisedFloat(Element element, String string, float defaultValue) throws Exception {
        if (!($assertionsDisabled || defaultValue >= 0.0f && defaultValue <= 1.0f)) {
            throw new AssertionError();
        }
        float val = XMLUtil.getFloat(element, string, defaultValue);
        val = val < 0.0f ? 0.0f : val;
        val = val > 1.0f ? 1.0f : val;
        return val;
    }
}

