/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sound;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALSource;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.openal.ALStreamInstance;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.util.PriorityPooled;
import org.lwjgl.Sys;
import org.lwjgl.openal.OpenALException;

public final class SoundEffect
implements PriorityPooled {
    final ALSource source = new ALSource();
    long age;
    private int priority;
    private Object owner;
    private SoundEffect link;
    private boolean locked;
    private boolean updatePosition;
    private boolean updateVelocity;
    private boolean updateGain;
    private boolean updatePitch;
    private boolean updateState;
    private boolean updateBuffer;
    private boolean updateLooping;
    private boolean updateAttenuated;
    private float x;
    private float y;
    private float z;
    private float dx;
    private float dy;
    private float dz;
    private float gain;
    private float pitch;
    boolean looped;
    boolean attenuated;
    int fadeTick;
    int fadeDuration;
    float initialGain;
    float finalGain;
    ALBuffer buffer;
    ALStreamInstance stream;
    int fadeType;
    private static final int FADE_NONE = 0;
    private static final int FADE_IN = 1;
    private static final int FADE_OUT = 2;
    private int state = -1;
    private static final int DO_PLAY = 0;
    private static final int DO_PAUSE = 1;
    private static final int DO_REWIND = 2;
    private static final int DO_STOP = 3;
    private final SoundPlayer player;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sound.SoundEffect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    SoundEffect(SoundPlayer player) {
        this.player = player;
    }

    private void doInit() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.dx = 0.0f;
        this.dy = 0.0f;
        this.dz = 0.0f;
        this.state = 0;
        this.fadeType = 0;
        this.fadeTick = 0;
        this.attenuated = true;
        this.updatePosition = true;
        this.updateVelocity = true;
        this.updateGain = true;
        this.updatePitch = true;
        this.updateState = true;
        this.updateLooping = true;
        this.updateAttenuated = true;
        this.source.set(4128, 1024.0f);
        this.source.set(4129, 1.0f);
        this.source.set(4109, 0.0f);
        this.source.set(4110, 1.0f);
        if (this.link != null) {
            this.link.deactivate();
            this.link = null;
        }
    }

    void init(ALStream stream) throws Exception {
        this.buffer = null;
        this.stream = stream.getInstance(this.source);
        this.pitch = stream.getPitch();
        this.gain = stream.getGain();
        this.looped = stream.isLooped();
        this.doInit();
    }

    void init(ALBuffer buf) {
        this.buffer = buf;
        this.stream = null;
        this.updateBuffer = true;
        this.pitch = this.buffer.getPitch();
        this.gain = this.buffer.getGain();
        this.looped = this.buffer.isLooped();
        this.doInit();
    }

    void update() {
        try {
            if (this.stream != null && this.stream.getOwner() != this.source) {
                System.out.println(this + " lost ownership of stream " + this.stream + " to " + this.stream.getOwner());
                this.stream = null;
                this.deactivate();
                return;
            }
            switch (this.fadeType) {
                case 1: {
                    this.gain = LinearInterpolator.instance.interpolate(this.initialGain, this.finalGain, (float)this.fadeTick / (float)this.fadeDuration);
                    ++this.fadeTick;
                    this.updateGain = true;
                    if (this.fadeTick < this.fadeDuration) break;
                    this.fadeType = 0;
                    break;
                }
                case 2: {
                    this.gain = LinearInterpolator.instance.interpolate(this.initialGain, this.finalGain, (float)this.fadeTick / (float)this.fadeDuration);
                    ++this.fadeTick;
                    this.updateGain = true;
                    if (this.fadeTick < this.fadeDuration) break;
                    this.fadeType = 0;
                    this.state = 3;
                    this.updateState = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            if (this.updatePosition) {
                this.source.set(4100, this.x, this.y, this.z);
                this.updatePosition = false;
            }
            if (this.updateVelocity) {
                this.source.set(4102, this.dx, this.dy, this.dz);
                this.updateVelocity = false;
            }
            if (this.updatePitch) {
                this.source.set(4099, this.pitch);
                this.updatePitch = false;
            }
            if (this.updateLooping) {
                this.source.setLooped(this.looped);
                this.updateLooping = false;
            }
            if (this.updateAttenuated) {
                this.source.set(4129, this.attenuated ? 1.0f : 0.0f);
                this.updateAttenuated = false;
            }
            if (this.updateGain) {
                this.source.set(4106, this.gain);
                this.updateGain = false;
            }
            if (this.updateBuffer) {
                if (this.buffer != null) {
                    this.source.attach(this.buffer);
                }
                this.updateBuffer = false;
            }
            if (this.updateState) {
                switch (this.state) {
                    case 0: {
                        if (this.stream != null) {
                            this.stream.setPlaying(true);
                            this.player.registerStream(this.stream);
                            break;
                        }
                        this.source.play();
                        break;
                    }
                    case 1: {
                        this.source.pause();
                        break;
                    }
                    case 2: {
                        this.source.rewind();
                        break;
                    }
                    case 3: {
                        if (this.stream != null) {
                            this.player.deregisterStream(this.stream);
                            this.stream.setPlaying(false);
                            this.deactivate();
                            return;
                        }
                        this.source.stop();
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            if (!this.updateState && Sys.getTime() - this.age > Sys.getTimerResolution()) {
                if (this.buffer != null) {
                    int sourceState = this.source.getInt(4112);
                    if (sourceState == 4116 || sourceState == 4113) {
                        this.deactivate();
                    }
                } else if (this.stream != null && !this.stream.isPlaying()) {
                    this.deactivate();
                }
            }
        }
        catch (OpenALException e) {
            this.deactivate();
        }
        this.updateState = false;
    }

    public void setPosition(float x, float y, float z, Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.updatePosition = true;
    }

    public void setVelocity(float dx, float dy, float dz, Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.updateVelocity = true;
    }

    public void setGain(float gain, Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.gain = gain;
        this.updateGain = true;
    }

    public void setPitch(float pitch, Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.pitch = pitch;
        this.updatePitch = true;
    }

    public void play(Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.state = 0;
        this.updateState = true;
    }

    public void pause(Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.state = 1;
        this.updateState = true;
    }

    public void stop(Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.state = 3;
        this.updateState = true;
    }

    public void rewind(Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.state = 2;
        this.updateState = true;
    }

    public void setLooped(boolean looped, Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.looped = looped;
        this.updateLooping = true;
    }

    public void setAttenuated(boolean attenuated, Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.attenuated = attenuated;
        this.updateAttenuated = true;
    }

    public void setFade(int duration, float finalGain, boolean stopAtEnd, Object owner) {
        if (!this.isOwnedBy(owner)) {
            return;
        }
        this.fadeDuration = duration;
        this.initialGain = this.gain;
        this.finalGain = finalGain;
        this.fadeTick = 0;
        this.fadeType = stopAtEnd ? 2 : 1;
    }

    public boolean isOwnedBy(Object owner) {
        return this.owner == owner;
    }

    public String toString() {
        if (this.buffer != null) {
            return "SoundEffect[source=" + this.source + " buffer=" + this.buffer + " owner=" + this.owner + "]";
        }
        if (this.stream != null) {
            return "SoundEffect[source=" + this.source + " stream=" + this.stream + " owner=" + this.owner + "]";
        }
        return "SoundEffect[source=" + this.source + " owner=" + this.owner + "]";
    }

    public boolean isActive() {
        return this.locked || (this.buffer != null || this.stream != null) && this.owner != null;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void unlock() {
        this.locked = false;
    }

    public void allocate(Object owner) {
        this.owner = owner;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void deactivate() {
        try {
            this.buffer = null;
            if (this.stream != null) {
                this.player.deregisterStream(this.stream);
                this.stream.setPlaying(false);
                this.stream = null;
            }
            this.owner = null;
            this.source.stop();
        }
        catch (OpenALException openALException) {
            // empty catch block
        }
        this.unlock();
        if (this.link != null) {
            this.link.deactivate();
            this.link = null;
        }
    }

    public void tick() {
        this.update();
    }

    public ALBuffer getBuffer() {
        return this.buffer;
    }

    public synchronized ALStreamInstance getStream() {
        return this.stream;
    }

    ALSource getSource() {
        return this.source;
    }

    void setLink(SoundEffect link) {
        this.link = link;
        if (link != null) {
            link.lock();
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newPriority) {
        this.priority = newPriority;
    }
}

