/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import java.util.StringTokenizer;
import org.lwjgl.util.Color;

public abstract class ColorParser {
    private ColorParser() {
    }

    public static Color parse(String in) throws Exception {
        StringTokenizer st;
        Color ret = new Color();
        if (in.startsWith("!")) {
            st = new StringTokenizer(in.substring(1), ", \t", false);
            if (!st.hasMoreTokens()) {
                throw new Exception("Missing hue value.");
            }
            int h = Integer.parseInt(st.nextToken());
            if (!st.hasMoreTokens()) {
                throw new Exception("Missing saturation value.");
            }
            int s = Integer.parseInt(st.nextToken());
            if (!st.hasMoreTokens()) {
                throw new Exception("Missing brightness value.");
            }
            int b = Integer.parseInt(st.nextToken());
            ret.fromHSB((float)h / 255.0f, (float)s / 255.0f, (float)b / 255.0f);
        } else {
            st = new StringTokenizer(in, ", \t", false);
            if (!st.hasMoreTokens()) {
                throw new Exception("Missing red value.");
            }
            ret.setRed(Integer.parseInt(st.nextToken()));
            if (!st.hasMoreTokens()) {
                throw new Exception("Missing green value.");
            }
            ret.setGreen(Integer.parseInt(st.nextToken()));
            if (st.hasMoreTokens()) {
                ret.setBlue(Integer.parseInt(st.nextToken()));
            } else {
                throw new Exception("Missing blue value.");
            }
        }
        if (st.hasMoreTokens()) {
            ret.setAlpha(Integer.parseInt(st.nextToken()));
        } else {
            ret.setAlpha(255);
        }
        return ret;
    }
}

