/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl.nvidia;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.opengl.nvidia.NvidiaMemory;
import java.nio.ByteBuffer;

public class AGPMemory {
    private static final String NVIDIA_AGP_MEMORY = "nvidia agp memory";
    private static NvidiaMemory memory;
    private static boolean initialised;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.nvidia.AGPMemory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private AGPMemory() {
    }

    public static Memory allocate(int len) throws Exception {
        if (!$assertionsDisabled && !initialised) {
            throw new AssertionError();
        }
        if (len == 0) {
            throw new IllegalArgumentException("Cannot allocate 0 bytes of AGP RAM!");
        }
        Memory newMemory = new Memory(NVIDIA_AGP_MEMORY, len);
        newMemory.create();
        return newMemory;
    }

    public static int getLength() {
        return AGPMemory.memory.memoryBuffer.capacity();
    }

    public static boolean isInitialised() {
        return initialised;
    }

    public static void reserve(int length) throws Exception {
        if (!$assertionsDisabled && initialised) {
            throw new AssertionError();
        }
        memory = new NvidiaMemory(NVIDIA_AGP_MEMORY, length, 0.0f, 0.0f, 0.5f);
        memory.create();
        initialised = true;
    }

    public static void unreserve() {
        if (!$assertionsDisabled && !initialised) {
            throw new AssertionError();
        }
        initialised = false;
        memory.destroy();
        memory = null;
    }

    public static ByteBuffer getBuffer() {
        return AGPMemory.memory.memoryBuffer;
    }

    public static boolean isAGPRAM() {
        return memory.isReserved();
    }
}

