/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.WrappedBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class DirectBufferAllocator {
    private static final Map memMap = new TreeMap();

    private DirectBufferAllocator() {
    }

    public static WrappedBuffer allocate(int size) {
        Integer iSize = new Integer(size);
        Iterator i = memMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Integer entrySize = (Integer)entry.getKey();
            WrappedBuffer wrapped = (WrappedBuffer)entry.getValue();
            if (!wrapped.isDisposed()) continue;
            if (entrySize >= size) {
                wrapped.allocate();
                return wrapped;
            }
            i.remove();
            wrapped.clear();
        }
        ByteBuffer data = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        WrappedBuffer wrapped = new WrappedBuffer(data);
        memMap.put(iSize, wrapped);
        return wrapped;
    }
}

