/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.util.BrowserControl;
import com.shavenpuppy.jglib.util.CheckOnline;
import java.io.IOException;
import java.rmi.Naming;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import net.puppygames.applet.AppletMessageCheckerRemote;
import net.puppygames.applet.Configuration;
import net.puppygames.applet.Game;
import net.puppygames.applet.MessageReturn;
import net.puppygames.applet.News;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.GenericButtonHandler;
import net.puppygames.applet.widgets.MessageBox;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class TitleScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static TitleScreen instance;
    private Rectangle registrationBounds;
    private Rectangle versionBounds;
    private Color colour;
    private transient GLTextArea registrationDetails;
    private transient GLTextArea versionString;
    private transient boolean messagesChecked;
    private transient boolean newsChecked;
    private transient List news;
    private transient News currentNews;
    private transient MessageReturn pendingMessage;
    private transient MessageBox messageBox;
    private transient boolean deregistrationChecked;

    public TitleScreen(String name) {
        super(name);
    }

    protected void doCreateScreen() throws Exception {
        this.registrationDetails = new GLTextArea();
        this.registrationDetails.setFont(Res.getTinyFont());
        this.registrationDetails.setHorizontalAlignment(TextLayout.CENTERED);
        this.registrationDetails.setVerticalAlignment(GLTextArea.CENTERED);
        this.registrationDetails.setBounds((ReadableRectangle)this.registrationBounds);
        this.versionString = new GLTextArea();
        this.versionString.setFont(Res.getTinyFont());
        this.versionString.setHorizontalAlignment(TextLayout.CENTERED);
        this.versionString.setVerticalAlignment(GLTextArea.CENTERED);
        this.versionString.setBounds((ReadableRectangle)this.versionBounds);
    }

    protected void doRegister() {
        instance = this;
    }

    public static void instantiate() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static TitleScreen getInstance() {
        return instance;
    }

    public static void show() {
        TitleScreen.instantiate();
        instance.open();
    }

    protected void doTick() {
        if (Game.wasKeyPressed(1)) {
            if (this.messageBox != null) {
                this.messageBox = null;
                this.setEnabled(true);
            } else if (this.isOpen()) {
                Game.exit();
            }
        }
        if (Mouse.isButtonDown((int)0) && this.messageBox != null) {
            this.messageBox = null;
            if (this.currentNews != null) {
                if (this.currentNews.getURL() != null) {
                    try {
                        BrowserControl.openURL((String)this.currentNews.getURL());
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
                this.currentNews = null;
            }
            this.setEnabled(true);
        }
        if (this.pendingMessage != null) {
            if (this.pendingMessage.getMessage() != null && this.pendingMessage.getTitle() != null) {
                this.messageBox = new MessageBox();
                this.messageBox.setSize(Game.getWidth() - 20, Game.getHeight() - 20);
                this.messageBox.setTitle(this.pendingMessage.getTitle());
                this.messageBox.setMessage(this.pendingMessage.getMessage());
                this.setEnabled(false);
            }
            if (this.pendingMessage.getReconfigure() != null) {
                try {
                    Game.setConfiguration((Configuration)this.pendingMessage.getReconfigure());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            this.pendingMessage = null;
        }
        if (this.news != null && this.news.size() > 0 && this.currentNews == null) {
            this.currentNews = (News)this.news.remove(0);
            this.messageBox = new MessageBox();
            this.messageBox.setSize(Game.getWidth() - 20, Game.getHeight() - 20);
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
            this.messageBox.setTitle(String.valueOf(df.format(this.currentNews.getDate().getTime())) + " NEWS");
            if (this.currentNews.getURL() != null) {
                this.messageBox.setMessage(String.valueOf(this.currentNews.getMessage()) + "\n\nClick to read more or hit ESC to continue");
            } else {
                this.messageBox.setMessage(String.valueOf(this.currentNews.getMessage()) + "\n\nClick mouse or hit ESC to continue");
            }
            this.setEnabled(false);
        }
    }

    protected void preRender() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.75f);
        this.registrationDetails.render();
        this.versionString.render();
        GL11.glPopMatrix();
        ColorUtil.setGLColor((ReadableColor)this.colour);
        this.registrationDetails.render();
        this.versionString.render();
        if (this.messageBox != null) {
            this.messageBox.render();
        }
    }

    protected void onClicked(String id) {
        GenericButtonHandler.onClicked(id);
    }

    protected void onOpen() {
        GenericButtonHandler.onOpen(this);
        try {
            SFX.createSFX();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.doUpdateRegistrationDetails();
        new Thread(){

            public void run() {
                if (Game.getDontCheckMessages() || !Game.isRemoteCallAllowed() || !CheckOnline.isOnline()) {
                    return;
                }
                if (TitleScreen.this.messagesChecked && TitleScreen.this.newsChecked && (TitleScreen.this.deregistrationChecked || Game.isRegistered())) {
                    return;
                }
                try {
                    AppletMessageCheckerRemote amcr;
                    block13: {
                        amcr = (AppletMessageCheckerRemote)Naming.lookup("//puppygames.net/message_checker");
                        if (!TitleScreen.this.messagesChecked && TitleScreen.this.pendingMessage == null) {
                            TitleScreen.this.messagesChecked = true;
                            TitleScreen.this.pendingMessage = amcr.checkForMessages(Game.getTitle(), Game.getVersion(), Game.getGame().getMessageSequence(), (ConfigurationDetails)Game.getConfiguration());
                        }
                        try {
                            if (TitleScreen.this.newsChecked || TitleScreen.this.news != null) break block13;
                            TitleScreen.this.newsChecked = true;
                            SimpleDateFormat df = new SimpleDateFormat("yyyyMMMdd");
                            String lastCheckedString = Game.getGlobalPreferences().get("lastnewscheck", "");
                            Date lastCheckedDate = null;
                            try {
                                lastCheckedDate = df.parse(lastCheckedString);
                            }
                            catch (Exception e) {
                                lastCheckedDate = new Date();
                            }
                            Calendar dayToCheckFrom = GregorianCalendar.getInstance();
                            dayToCheckFrom.setTime(lastCheckedDate);
                            TitleScreen.this.news = amcr.getNews(dayToCheckFrom);
                            dayToCheckFrom.setLenient(true);
                            dayToCheckFrom.add(6, 1);
                            Game.getGlobalPreferences().put("lastnewscheck", df.format(dayToCheckFrom.getTime()));
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        if (!TitleScreen.this.deregistrationChecked && Game.isRegistered() && Game.getRegistrationDetails() != null) {
                            TitleScreen.this.deregistrationChecked = true;
                            boolean stillRegistered = amcr.checkRegistrationValid(Game.getRegistrationDetails());
                            if (!stillRegistered) {
                                Game.setRegistrationDetails(null);
                                TitleScreen.updateRegistrationDetails();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    public static void updateRegistrationDetails() {
        TitleScreen.instantiate();
        instance.doUpdateRegistrationDetails();
    }

    private void doUpdateRegistrationDetails() {
        RegistrationDetails regDetails;
        if (this.getArea("buy") != null) {
            this.getArea("buy").setVisible(!Game.isRegistered());
        }
        if (this.getArea("moregames") != null) {
            this.getArea("moregames").setVisible(!Game.isRegistered());
        }
        if ((regDetails = Game.getRegistrationDetails()) == null) {
            this.registrationDetails.setText("");
        } else {
            this.registrationDetails.setText(regDetails.toTitleScreen().toUpperCase());
        }
        if (Game.isRegistered()) {
            this.versionString.setText("v" + Game.getVersion());
        } else {
            this.versionString.setText("v" + Game.getVersion() + " demo");
        }
    }
}

