/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.Background;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.util.StringTokenizer;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import net.puppygames.applet.effects.BackgroundStyle;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import net.puppygames.applet.effects.SFX;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public class Area
extends Feature
implements Tickable {
    public static final long serialVersionUID = 1L;
    private String id;
    private String group;
    private String mouseOff;
    private String mouseOn;
    private String disabled;
    private Point position;
    private Dimension size;
    private Point offset;
    private boolean noClick;
    private boolean debug;
    private int layer;
    private boolean visible = true;
    private String font;
    private String text;
    private Color color = new Color(Color.WHITE);
    private String leftFocus;
    private String rightFocus;
    private String upFocus;
    private String downFocus;
    private String nextFocus;
    private String prevFocus;
    private boolean defaultFocus;
    private boolean mirrored;
    private boolean flipped;
    private String background;
    private int bglayer;
    private boolean hasSize;
    private boolean hasPosition;
    private boolean textAsSubTag;
    private Point textOffset;
    private String emitter;
    private Point emitterOffset;
    private String link;
    private float scale = 1.0f;
    private transient AnimatedAppearanceResource mouseOnResource;
    private transient AnimatedAppearanceResource mouseOffResource;
    private transient AnimatedAppearanceResource disabledResource;
    private transient Sprite sprite;
    private transient Rectangle bounds;
    private transient Screen screen;
    private transient boolean ignoreMouse;
    private transient boolean enabled;
    private transient GLTextArea textArea;
    private transient String[] groups;
    private transient Background backgroundResource;
    private transient Sprite backgroundSprite;
    private transient GLFont fontResource;
    private transient boolean selectDown;
    private transient boolean armed;
    private transient EmitterFeature emitterFeature;
    private transient AnimatedAppearance currentAppearance;
    private transient Background.Instance backgroundInstance;
    private transient Emitter emitterInstance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Area");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Area() {
        this.setSubResource(true);
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            SpriteImage image;
            if (this.sprite != null && (image = this.sprite.getImage()) != null) {
                this.bounds = new Rectangle(this.sprite.getX(), this.sprite.getY(), image.getWidth(), image.getHeight());
            }
            if (this.bounds == null) {
                this.bounds = new Rectangle(0, 0, 0, 0);
            }
        }
        if (!$assertionsDisabled && this.bounds == null) {
            throw new AssertionError();
        }
        return this.bounds;
    }

    public int getLayer() {
        return this.layer;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        if (this.id == null) {
            throw new Exception("Missing id attribute in area");
        }
        if (this.size != null) {
            this.hasSize = true;
        }
        if (this.position != null) {
            this.hasPosition = true;
        }
        if (this.text == null && XMLUtil.hasChild((Element)element, (String)"text")) {
            this.text = XMLUtil.getText((Element)XMLUtil.getChild((Element)element, (String)"text"), (String)"<missing text>");
            this.textAsSubTag = true;
        }
    }

    public void init() {
        if (this.sprite != null && this.mouseOffResource != null) {
            this.sprite.setAppearance((AnimatedAppearance)this.mouseOffResource);
            this.sprite.rewind();
            if (this.offset != null) {
                this.sprite.setOffset(this.offset.getX(), this.offset.getY(), 0);
            }
            if (this.scale != 1.0f) {
                this.sprite.setScale(FPMath.fpValue((float)this.scale));
            }
        }
        if (this.emitterFeature != null) {
            this.initEmitter();
        }
        this.doSetVisible(this.visible);
    }

    private void initEmitter() {
        int oy;
        int ox;
        this.emitterInstance = this.emitterFeature.spawn(this.getScreen());
        if (this.emitterOffset != null) {
            ox = this.emitterOffset.getX();
            oy = this.emitterOffset.getY();
        } else {
            ox = 0;
            oy = 0;
        }
        this.emitterInstance.setLocation(this.position.getX() + ox, this.position.getY() + oy);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.group != null) {
            StringTokenizer st = new StringTokenizer(this.group, ",", false);
            this.groups = new String[st.countTokens()];
            int count = 0;
            while (st.hasMoreTokens()) {
                this.groups[count] = st.nextToken().trim();
                ++count;
            }
        }
        if (this.mouseOffResource != null && this.mouseOffResource instanceof SpriteImage) {
            SpriteImage img = (SpriteImage)this.mouseOffResource;
            this.bounds = new Rectangle(this.position.getX() - img.getHotspotX(), this.position.getY() - img.getHotspotY(), img.getWidth(), img.getHeight());
        }
        if (this.size == null) {
            // empty if block
        }
        if (this.size != null && this.position != null) {
            this.bounds = new Rectangle((ReadablePoint)this.position, (ReadableDimension)this.size);
        }
        if (this.text != null) {
            this.createTextArea();
        }
        this.enabled = true;
    }

    protected void doDestroy() {
        super.doDestroy();
        this.cleanup();
    }

    public void spawn(Screen newScreen) {
        this.screen = newScreen;
        newScreen.addTickable(this);
        if (this.mouseOffResource != null) {
            this.sprite = newScreen.allocateSprite(this);
            if (this.sprite == null) {
                System.err.println("Failed to create " + this + ": no sprite available");
                this.destroy();
            } else {
                this.sprite.setLayer(this.layer);
                this.sprite.setLocation(this.position.getX(), this.position.getY(), 0);
                this.sprite.setMirrored(this.mirrored);
                this.sprite.setFlipped(this.flipped);
            }
        }
        if (this.backgroundResource != null) {
            this.backgroundInstance = this.backgroundResource.spawn();
            this.backgroundInstance.setColor((ReadableColor)this.color);
            this.backgroundInstance.setSize((ReadableDimension)this.bounds);
            this.backgroundSprite = this.screen.allocateSprite(this);
            this.backgroundSprite.setLayer(this.bglayer);
            this.backgroundSprite.setStyle((Style)new BackgroundStyle(this.backgroundInstance, (ReadablePoint)this.bounds));
            this.backgroundSprite.setVisible(this.visible);
        }
    }

    public void cleanup() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
        if (this.backgroundSprite != null) {
            this.backgroundSprite.deallocate();
            this.backgroundSprite = null;
        }
        if (this.emitterInstance != null) {
            this.emitterInstance.remove();
            this.emitterInstance = null;
        }
        this.currentAppearance = null;
    }

    public void update() {
    }

    public void tick() {
        if (!this.screen.isOpen()) {
            return;
        }
        if (this.screen.getGrabbed() != null && this.screen.getGrabbed() != this) {
            return;
        }
        boolean clicked = false;
        this.selectDown = false;
        boolean wasArmed = this.armed;
        this.armed = false;
        if (this.isVisible()) {
            if (this.screen.isKeyboardNavigationEnabled()) {
                this.selectDown = Keyboard.isKeyDown((int)57) || Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)28) || Binding.isBindingDown("select.binding") || Binding.isBindingDown("select.binding.alt");
                boolean bl = this.armed = this.isFocused() && this.isFocusable();
                if (this.selectDown && this.armed) {
                    clicked = true;
                } else {
                    boolean mouseArmed;
                    this.selectDown = Mouse.isButtonDown((int)0);
                    boolean bl2 = mouseArmed = this.getBounds() != null && this.getBounds().contains(this.screen.getMouseX(), this.screen.getMouseY());
                    if (this.selectDown && mouseArmed) {
                        clicked = true;
                        if (this.enabled && this.screen.isEnabled()) {
                            this.requestFocus();
                        }
                    } else {
                        this.armed |= mouseArmed;
                    }
                }
            } else {
                this.selectDown = Mouse.isButtonDown((int)0);
                this.armed = this.getBounds().contains(this.screen.getMouseX(), this.screen.getMouseY());
                if (this.selectDown && this.armed) {
                    clicked = true;
                }
            }
            if (this.sprite != null) {
                if (this.mouseOnResource != null && this.armed && this.enabled && this.screen.isEnabled()) {
                    if (this.currentAppearance != this.mouseOnResource) {
                        if (this.visible && !this.noClick) {
                            SFX.buttonHover();
                            this.screen.onHover(this.id, true);
                        }
                        this.setAppearance((AnimatedAppearance)this.mouseOnResource);
                    }
                } else if (this.enabled && this.screen.isEnabled() && this.mouseOffResource != null) {
                    if (this.currentAppearance != this.mouseOffResource) {
                        this.setAppearance((AnimatedAppearance)this.mouseOffResource);
                        this.screen.onHover(this.id, false);
                    }
                } else if (this.disabledResource != null) {
                    this.setAppearance((AnimatedAppearance)this.disabledResource);
                }
            } else if (this.armed && this.enabled && this.screen.isEnabled()) {
                if (this.visible && !this.noClick && !wasArmed) {
                    SFX.buttonHover();
                    this.screen.onHover(this.id, true);
                }
            } else if (wasArmed) {
                this.screen.onHover(this.id, false);
            }
            if (this.selectDown && this.visible && this.armed && !this.noClick && !this.ignoreMouse && this.enabled && this.screen.isEnabled() && clicked) {
                SFX.buttonClick();
                this.ignoreMouse = true;
                this.screen.onClicked(this.id);
            } else if (!this.selectDown) {
                this.ignoreMouse = false;
            }
        }
    }

    private void setAppearance(AnimatedAppearance appearance) {
        if (this.sprite == null || this.currentAppearance == appearance) {
            return;
        }
        this.sprite.setAnimation(null);
        this.sprite.setAppearance(appearance);
        this.currentAppearance = appearance;
    }

    public void render() {
        if (this.textArea != null && this.visible) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            ColorUtil.setGLColor((ReadableColor)this.color);
            this.textArea.render();
        }
        if (this.position != null && this.size != null && this.debug) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            GL11.glBegin((int)7);
            GL11.glVertex2i((int)this.position.getX(), (int)this.position.getY());
            GL11.glVertex2i((int)(this.position.getX() + this.size.getWidth()), (int)this.position.getY());
            GL11.glVertex2i((int)(this.position.getX() + this.size.getWidth()), (int)(this.position.getY() + this.size.getHeight()));
            GL11.glVertex2i((int)this.position.getX(), (int)(this.position.getY() + this.size.getHeight()));
            GL11.glEnd();
        }
    }

    public String getID() {
        return this.id;
    }

    public String toString() {
        return "Area[" + this.id + "]";
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            if (this.link != null) {
                Area linked = this.screen.getArea(this.link);
                if (linked != null) {
                    linked.setVisible(visible);
                } else {
                    System.out.println("Linked area '" + this.link + "' does not exist");
                }
            }
            return;
        }
        this.doSetVisible(visible);
    }

    protected void doSetVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.ignoreMouse = true;
        }
        if (this.sprite != null) {
            this.sprite.setVisible(visible);
            if (visible) {
                this.mouseOffResource.toAnimated((Animated)this.sprite);
                this.currentAppearance = this.mouseOffResource;
                this.sprite.setActive(true);
            } else {
                this.currentAppearance = null;
                this.sprite.setActive(false);
            }
        }
        if (this.backgroundSprite != null) {
            this.backgroundSprite.setVisible(visible);
            this.sprite.setActive(visible);
        }
        if (this.emitterInstance != null) {
            if (!visible) {
                this.emitterInstance.remove();
                this.emitterInstance = null;
            }
        } else if (this.emitterFeature != null) {
            this.initEmitter();
        }
        if (this.link != null) {
            Area linked = this.screen.getArea(this.link);
            if (linked != null) {
                linked.doSetVisible(visible);
            } else {
                System.out.println("Linked area '" + this.link + "' does not exist");
            }
        }
        if (visible && this.isFocusable()) {
            this.requestFocus();
        }
    }

    public void setAlpha(int alpha) {
        if (this.sprite != null) {
            this.sprite.setAlpha(alpha);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.sprite != null) {
            if (enabled) {
                this.setAppearance((AnimatedAppearance)this.mouseOffResource);
            } else if (this.disabledResource != null) {
                this.setAppearance((AnimatedAppearance)this.disabledResource);
            }
        }
        if (this.link != null) {
            Area linked = this.screen.getArea(this.link);
            if (linked != null) {
                linked.setEnabled(enabled);
            } else {
                System.out.println("Linked area '" + this.link + "' does not exist");
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isActive() {
        return this.isCreated();
    }

    public void remove() {
    }

    public String getNextFocus() {
        return this.nextFocus;
    }

    public String getPrevFocus() {
        return this.prevFocus;
    }

    public String getLeftFocus() {
        return this.leftFocus;
    }

    public String getRightFocus() {
        return this.rightFocus;
    }

    public String getUpFocus() {
        return this.upFocus;
    }

    public String getDownFocus() {
        return this.downFocus;
    }

    public boolean isFocused() {
        return this.screen.getFocus() == this && this.screen.isKeyboardNavigationEnabled() && this.visible && this.enabled && !this.noClick;
    }

    public boolean isDefaultFocus() {
        return this.defaultFocus;
    }

    public boolean isFocusable() {
        return this.visible && this.enabled && !this.noClick;
    }

    public boolean isInGroup(String groupToCheck) {
        if (groupToCheck == null || this.groups == null) {
            return false;
        }
        int i = 0;
        while (i < this.groups.length) {
            if (groupToCheck.equals(this.groups[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void requestFocus() {
        this.screen.requestFocus(this);
    }

    public Background.Instance getBackground() {
        return this.backgroundInstance;
    }

    public SpriteImage getCurrentImage() {
        return this.sprite != null ? this.sprite.getImage() : null;
    }

    public ReadablePoint getPosition() {
        return this.position;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.bounds.setBounds(x, y, w, h);
        if (this.sprite != null) {
            this.sprite.setLocation(x, y, 0);
        }
        if (this.hasSize) {
            this.size.setSize(w, h);
        }
        if (this.hasPosition) {
            this.position.setLocation(x, y);
        }
        if (this.textArea != null) {
            this.updateTextBounds();
        }
        if (this.backgroundInstance != null) {
            this.backgroundInstance.setSize(w, h);
        }
    }

    public void setTextOffset(int x, int y) {
        this.textOffset = x == 0 && y == 0 ? null : new Point(x, y);
        this.updateTextBounds();
    }

    public ReadablePoint getTextOffset() {
        if (this.textOffset == null) {
            return new Point();
        }
        return this.textOffset;
    }

    private void updateTextBounds() {
        if (this.textArea == null || this.bounds == null) {
            return;
        }
        int x = this.bounds.getX();
        int y = this.bounds.getY();
        int w = this.bounds.getWidth();
        int h = this.bounds.getHeight();
        if (this.textOffset != null) {
            x += this.textOffset.getX();
            y += this.textOffset.getY();
        }
        this.textArea.setBounds(x, y, w, h);
    }

    protected boolean shouldWriteAttribute(String attribute) {
        return !"text".equals(attribute) && !"textAsSubTag".equals(attribute) && !"hasSize".equals(attribute) && !"hasPosition".equals(attribute) && (!"size".equals(attribute) || this.hasSize) && (!"position".equals(attribute) || this.hasPosition);
    }

    protected void doWriteAttributes(XMLResourceWriter writer) throws IOException {
        if (!this.textAsSubTag) {
            writer.writeAttribute("text", (Object)this.text);
        }
    }

    protected void doWriteChildren(XMLResourceWriter writer) throws IOException {
        if (this.textAsSubTag) {
            writer.writeTag("text");
            writer.writeText(this.text);
            writer.closeTag();
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.textArea == null && text != null) {
            this.createTextArea();
        } else if (this.textArea != null && text == null) {
            this.textArea = null;
        } else if (this.textArea != null && text != null) {
            this.textArea.setText(text);
        }
    }

    private void createTextArea() {
        this.textArea = new GLTextArea();
        this.textArea.setFont(this.fontResource);
        this.textArea.setText(this.text);
        this.textArea.setVerticalAlignment(GLTextArea.TOP);
        this.textArea.setHorizontalAlignment(TextLayout.CENTERED);
        this.updateTextBounds();
    }

    public boolean isSelectDown() {
        return this.selectDown;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setOffset(int x, int y) {
        this.offset = x == 0 && y == 0 ? null : new Point(x, y);
        if (this.sprite != null) {
            this.sprite.setOffset(x, y, 0);
        }
    }

    public ReadablePoint getOffset() {
        return this.offset;
    }
}

