/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import invaders.Behaviour;
import invaders.Gidrah;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Rotating
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private float rotation;
    private float distance;

    public Rotating(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new RotatingInstance(gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathRandom();
    }

    private static class RotatingInstance
    extends Behaviour.Instance {
        private static final long serialVersionUID = 1L;
        float initialX;
        float initialY;
        boolean free;
        private transient Rotating behaviour;

        public RotatingInstance(Gidrah gidrah) {
            super(gidrah);
            this.behaviour = (Rotating)gidrah.getBehaviour();
            this.initialX = this.getMaster().getX();
            this.initialY = this.getMaster().getY();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (Rotating)this.gidrah.getBehaviour();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        public float getVX() {
            return 0.0f;
        }

        protected void doTick() {
            if (this.getMaster().isActive()) {
                this.initialX = this.getMaster().getX();
                this.initialY = this.getMaster().getY();
            } else if (!this.gidrah.isCritical()) {
                this.gidrah.criticalHit();
                return;
            }
            double angle = this.getAngle() + (double)this.behaviour.rotation;
            if (angle >= 360.0) {
                angle -= 360.0;
            } else if (angle < 0.0) {
                angle += 360.0;
            }
            this.setAngle(angle);
            angle = Math.toRadians(angle);
            this.gidrah.setLocation(this.initialX + (float)Math.cos(angle) * this.behaviour.distance, this.initialY + (float)Math.sin(angle) * this.behaviour.distance);
        }
    }
}

