/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.resources.Range;
import invaders.Behaviour;
import invaders.Gidrah;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;

public class DiveBomb
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private float speed;
    private float acceleration;
    private float distance;
    private float rotation;
    private Range wait;
    static /* synthetic */ Class class$0;

    public DiveBomb(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new Instance(this, gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathGalaxian();
    }

    private static class Instance
    extends Behaviour.Instance {
        private static final long serialVersionUID = 1L;
        private int tick;
        private int moves;
        private float vx;
        private float vy;
        private float ox;
        private float oy;
        private float angle;
        private int returnDuration;
        private float rx;
        private float ry;
        private float dist;
        private int phase;
        private static final int PHASE_WAIT = 0;
        private static final int PHASE_DIVE = 1;
        private static final int PHASE_RETURN = 2;
        private transient DiveBomb behaviour;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("invaders.behaviours.DiveBomb");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public Instance(DiveBomb behaviour, Gidrah gidrah) {
            super(gidrah);
            this.behaviour = behaviour;
            gidrah.setAutoRemove(false);
            this.tick = (int)behaviour.wait.getValue();
        }

        public void init() {
            this.ox = this.gidrah.getX();
            this.oy = this.gidrah.getY();
        }

        public float getVX() {
            return this.vx;
        }

        protected void doTick() {
            float x = this.gidrah.getX();
            float y = this.gidrah.getY();
            switch (this.phase) {
                case 0: {
                    --this.tick;
                    if (this.tick <= 0) {
                        this.phase = 1;
                    }
                    this.angle += this.behaviour.rotation;
                    if (this.dist < this.behaviour.distance) {
                        this.dist += this.behaviour.distance / 60.0f;
                    }
                    float newx = this.ox + (float)Math.cos(Math.toRadians(this.angle)) * this.dist;
                    float newy = this.oy + (float)Math.sin(Math.toRadians(this.angle)) * this.dist;
                    this.vx = newx - x;
                    this.vy = newy - y;
                    this.gidrah.setLocation(newx, newy);
                    break;
                }
                case 1: {
                    this.vy = Math.max(-this.behaviour.speed, this.vy - this.behaviour.acceleration);
                    y += this.vy;
                    this.vx *= 0.99f;
                    if ((x += this.vx) < this.gidrah.getRadius() || x >= (float)Game.getWidth() - this.gidrah.getRadius()) {
                        this.vx = -this.vx;
                    }
                    if (y < -this.gidrah.getRadius() * 2.0f) {
                        this.ox = x;
                        y = (float)Game.getHeight() + this.gidrah.getRadius() * 2.0f;
                        this.returnDuration = (int)Math.max(1.0f, Math.abs(y - this.oy) / this.behaviour.speed);
                        this.rx = x;
                        this.ry = y;
                        this.phase = 2;
                        this.tick = 0;
                    }
                    this.gidrah.setLocation(x, y);
                    break;
                }
                case 2: {
                    ++this.tick;
                    if (this.tick >= this.returnDuration) {
                        this.phase = 0;
                        this.dist = 0.0f;
                        this.tick = (int)this.behaviour.wait.getValue();
                        break;
                    }
                    float ratio = (float)this.tick / (float)this.returnDuration;
                    this.gidrah.setLocation(CosineInterpolator.instance.interpolate(this.rx, this.ox, ratio), CosineInterpolator.instance.interpolate(this.ry, this.oy, ratio));
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (DiveBomb)this.gidrah.getBehaviour();
        }
    }
}

