/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import invaders.Res;
import invaders.ShowPowerDisplay;
import java.util.Iterator;
import java.util.List;
import net.puppygames.applet.Screen;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public class ShopPowerDisplayFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private String[] barAnimation;
    private String unusedAnimation;
    private int gap;
    private Point location;
    private int layer;
    private int priceWidth;
    private Point offset;
    private transient Animation[] barAnimationResource;
    private transient Animation unusedAnimationResource;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("invaders.ShopPowerDisplayFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ShopPowerDisplayFeature() {
        this.setAutoCreated();
    }

    public ShopPowerDisplayFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List bars = XMLUtil.getChildren((Element)element, (String)"bar");
        this.barAnimation = new String[bars.size()];
        int count = 0;
        Iterator i = bars.iterator();
        while (i.hasNext()) {
            Element barElement = (Element)i.next();
            String bar = XMLUtil.getText((Element)barElement, (String)"--missing bar animation--");
            this.barAnimation[count++] = bar;
        }
        if (this.priceWidth == 0) {
            this.offset = new Point();
        }
        if (!$assertionsDisabled && this.location == null) {
            throw new AssertionError((Object)this);
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.barAnimationResource = new Animation[this.barAnimation.length];
        int i = 0;
        while (i < this.barAnimation.length) {
            this.barAnimationResource[i] = (Animation)Resources.get((String)this.barAnimation[i]);
            ++i;
        }
    }

    public ShowPowerDisplay spawn(Screen screen) {
        ShowPowerDisplay ret = new ShowPowerDisplay(){
            Sprite[] sprite;
            GLString priceString;
            int x;
            int y;
            int used = -1;

            public void setUsed(int used) {
                if (this.used == used) {
                    return;
                }
                this.used = used;
                int i = 0;
                while (i < Math.min(this.sprite.length, used)) {
                    this.sprite[i].setAnimation(ShopPowerDisplayFeature.this.barAnimationResource[i]);
                    ++i;
                }
                i = Math.max(0, used);
                while (i < this.sprite.length) {
                    this.sprite[i].setAnimation(ShopPowerDisplayFeature.this.unusedAnimationResource);
                    ++i;
                }
            }

            public void setLocation(int x, int y) {
                this.x = x;
                this.y = y;
                this.updatePriceLocation();
                int i = 0;
                while (i < this.sprite.length) {
                    this.sprite[i].setLocation(x + ShopPowerDisplayFeature.this.offset.getX(), y + ShopPowerDisplayFeature.this.offset.getY(), 0);
                    x += ShopPowerDisplayFeature.this.gap;
                    ++i;
                }
            }

            public void setPrice(int price) {
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                if (price == -1) {
                    this.priceString.setText("");
                } else {
                    this.priceString.setText("$" + price);
                }
                this.updatePriceLocation();
            }

            private void updatePriceLocation() {
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                Rectangle bounds = this.priceString.getBounds(null);
                this.priceString.setLocation(this.x + ShopPowerDisplayFeature.this.priceWidth - bounds.getWidth(), this.y);
            }

            public void render() {
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                this.priceString.render();
            }

            public void init(Screen screen) {
                this.sprite = new Sprite[ShopPowerDisplayFeature.this.barAnimation.length];
                int i = 0;
                while (i < this.sprite.length) {
                    this.sprite[i] = screen.allocateSprite((Object)this);
                    if (this.sprite[i] == null) {
                        throw new RuntimeException("Ran out of sprites");
                    }
                    this.sprite[i].setLayer(ShopPowerDisplayFeature.this.layer);
                    ++i;
                }
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                this.priceString = new GLString(6);
                this.priceString.setFont(Res.getSmallFont());
            }

            public void cleanup() {
                if (this.sprite == null) {
                    return;
                }
                int i = 0;
                while (i < this.sprite.length) {
                    this.sprite[i].deallocate();
                    ++i;
                }
                this.sprite = null;
            }
        };
        ret.init(screen);
        ret.setLocation(this.location.getX(), this.location.getY());
        ret.setUsed(0);
        return ret;
    }
}

