/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import invaders.Bullet;
import invaders.EnemyBullet;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Laser;
import invaders.Parachute;
import invaders.Player;
import invaders.Powerup;
import invaders.Saucer;
import invaders.Smartbomb;
import invaders.Turret;
import java.io.Serializable;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import org.lwjgl.util.vector.Vector2f;

public abstract class Entity
implements Tickable,
Serializable {
    private float x;
    private float y;
    private boolean active = true;
    private boolean visible = true;
    private boolean flash;
    private Sprite sprite;

    public float getDistanceTo(float xx, float yy) {
        return Vector2f.sub((Vector2f)new Vector2f(xx, yy), (Vector2f)new Vector2f(this.getX(), this.getY()), null).length();
    }

    public final void setAppearance(AnimatedAppearance appearance) {
        this.sprite.setAppearance(appearance);
    }

    protected final AnimatedAppearance getAppearance() {
        Animation ret = this.sprite.getAnimation();
        if (ret == null) {
            ret = this.sprite.getImage();
        }
        return ret;
    }

    public final void respawn(Screen screen) {
        screen.addTickable((Tickable)this);
        this.doRespawn();
    }

    protected abstract void doRespawn();

    public final void spawn(Screen screen) {
        this.sprite = screen.allocateSprite((Object)this);
        if (this.sprite == null) {
            this.remove();
            return;
        }
        GameScreen.addEntity(this);
        this.doSpawn();
    }

    protected void doSpawn() {
    }

    public abstract boolean canCollide();

    public final boolean isActive() {
        return this.active;
    }

    public final void remove() {
        this.removeSprite();
        if (!this.active) {
            return;
        }
        this.active = false;
        this.doRemove();
    }

    protected final void removeSprite() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
    }

    protected void doRemove() {
    }

    public abstract void onCollision(Entity var1);

    public void onCollisionWithPlayer(Player player) {
    }

    public void onCollisionWithGidrah(Gidrah gidrah) {
    }

    public void onCollisionWithBullet(Bullet bullet) {
    }

    public void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
    }

    public void onCollisionWithSmartbomb(Smartbomb smartBomb) {
    }

    public void onCollisionWithPowerup(Powerup powerup) {
    }

    public void onCollisionWithSaucer(Saucer saucer) {
    }

    public void onCollisionWithLaser(Laser laser) {
    }

    public void onCollisionWithTurret(Turret turret) {
    }

    public void onCollisionWithParachute(Parachute parachute) {
    }

    public abstract float getRadius();

    public final boolean isTouching(Entity dest) {
        if (!this.canCollide() || !dest.canCollide() || this.getRadius() == 0.0f || dest.getRadius() == 0.0f) {
            return false;
        }
        float dx = dest.x - this.x;
        float dy = dest.y - this.y;
        return Math.sqrt((dx *= dx) + (dy *= dy)) < (double)(this.getRadius() + dest.getRadius());
    }

    public final void tick() {
        try {
            this.doTick();
        }
        catch (Exception e) {
            System.err.println("Error ticking " + this);
            e.printStackTrace(System.err);
            this.remove();
        }
        if (this.isActive()) {
            if (this.autoRemove() && (this.x < -this.getRadius() * 3.0f || this.x > (float)Game.getWidth() + this.getRadius() * 3.0f || this.y < -this.getRadius() * 3.0f || this.y > (float)Game.getHeight() + this.getRadius() * 3.0f)) {
                this.onAutoRemove();
                this.remove();
            } else if (this.sprite != null) {
                this.sprite.setLocation((int)this.x, (int)this.y, 0);
                this.sprite.setVisible(this.visible);
                this.sprite.setFlash(this.flash);
            } else {
                this.remove();
            }
        }
    }

    protected void onAutoRemove() {
    }

    protected void doTick() {
    }

    public void update() {
    }

    protected boolean autoRemove() {
        return true;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final void setAngle(int angle) {
        if (this.sprite != null) {
            this.sprite.setAngle(angle);
        }
    }

    public int getAngle() {
        return this.sprite.getAngle();
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setFlash(boolean flash) {
        this.flash = flash;
    }

    public final boolean isFlashing() {
        return this.flash;
    }

    public final void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public abstract boolean canCollideWithLaser();

    public final int getEvent() {
        if (this.sprite == null) {
            return 0;
        }
        return this.sprite.getEvent();
    }

    public final void setEvent(int event) {
        this.sprite.setEvent(event);
    }

    public void setLayer(int newLayer) {
        this.sprite.setLayer(newLayer);
    }

    public void setOffset(int x, int y) {
        this.sprite.setOffset(x, y, 0);
    }

    public void setAlpha(int alpha) {
        this.sprite.setAlpha(alpha);
    }
}

