/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.sprites.Angled;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;

public class AngleCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int delta;
    private boolean relative;
    private int duration;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            Angled angledTarget = (Angled)((Object)target);
            if (this.relative) {
                angledTarget.adjustAngle(this.delta);
            } else {
                angledTarget.setAngle(this.delta);
            }
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick + tickRate);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String sdelta = XMLUtil.getString(element, "angle");
        if (sdelta.startsWith("+")) {
            this.relative = true;
            this.delta = Integer.parseInt(sdelta.substring(1));
        } else if (sdelta.startsWith("-")) {
            this.relative = true;
            this.delta = Integer.parseInt(sdelta);
        } else {
            this.delta = Integer.parseInt(sdelta);
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doCreate() throws Exception {
    }

    protected void doDestroy() {
    }
}

