/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.ResourceConverter;
import com.shavenpuppy.jglib.resources.ResourceLoadedListener;
import java.io.BufferedInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DynamicResource
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final Map DYNAMIC_RESOURCES_MAP = new HashMap();
    private String url;
    private transient ResourceLoadedListener listener;

    public DynamicResource(String name) {
        super(name);
    }

    public DynamicResource(String name, String url) {
        super(name);
        this.url = url;
    }

    protected void doRegister() {
        DYNAMIC_RESOURCES_MAP.put(this.getName(), this);
    }

    protected void doDeregister() {
        DYNAMIC_RESOURCES_MAP.remove(this.getName());
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        BufferedInputStream bis = this.url.startsWith("classpath:") ? new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))) : new BufferedInputStream(new URL(this.url).openStream());
        ResourceConverter loader = new ResourceConverter(this.listener);
        loader.setOverwrite(true);
        loader.include(bis);
    }

    public static void createAll() throws Exception {
        Iterator i = DYNAMIC_RESOURCES_MAP.values().iterator();
        while (i.hasNext()) {
            DynamicResource dr = (DynamicResource)i.next();
            if (dr.isCreated()) {
                dr.destroy();
            }
            dr.create();
        }
    }

    public void setListener(ResourceLoadedListener listener) {
        this.listener = listener;
    }

    public ResourceLoadedListener getListener() {
        return this.listener;
    }
}

