/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.shared;

import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.Countries;
import net.puppygames.gamecommerce.shared.CreditCard;
import net.puppygames.gamecommerce.shared.Game;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PaymentDetails
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String cc_name;
    private String address1;
    private String address2;
    private String address3;
    private String stateOrCounty;
    private String postCode;
    private String country;
    private int cc_expiry_month;
    private int cc_expiry_year;
    private String cc_number;
    private String cc_security;
    private int cc_start_month;
    private int cc_start_year;
    private int cc_issue_number;
    private CreditCard cc_type;
    private String email;
    private String phone;
    private char[] password;
    private String delivery_name;
    private long installation;
    private String gameTitle;
    private String version;
    private String affiliate;
    private ConfigurationDetails configuration;

    public PaymentDetails(Game game) {
        this.gameTitle = game.getTitle();
        this.version = game.getVersion();
        this.affiliate = game.getAffiliate();
        this.configuration = game.getConfiguration();
    }

    public void toUserDetailsSetter(UserDetailsSetter editor) {
        editor.setEmail(this.email);
        editor.setPassword(this.password);
        editor.setPhone(this.phone);
        editor.setDeliveryName(this.delivery_name);
    }

    public void fromUserDetailsGetter(UserDetailsGetter editor) {
        this.email = editor.getEmail();
        this.password = editor.getPassword();
        this.phone = editor.getPhone();
        this.delivery_name = editor.getDeliveryName();
    }

    public void toCreditCardDetailsSetter(CreditCardDetailsSetter editor) {
        editor.setCCExpiryMonth(this.cc_expiry_month);
        editor.setCCExpiryYear(this.cc_expiry_year);
        editor.setCCName(this.cc_name);
        editor.setCCNumber(this.cc_number);
        editor.setCCStartMonth(this.cc_start_month);
        editor.setCCStartYear(this.cc_start_year);
        editor.setCCIssueNumber(this.cc_issue_number);
        editor.setCCType(this.cc_type);
        editor.setCCSecurity(this.cc_security);
    }

    public void fromCreditCardDetailsGetter(CreditCardDetailsGetter editor) {
        this.cc_name = editor.getCCName();
        this.cc_number = editor.getCCNumber();
        this.cc_expiry_month = editor.getCCExpiryMonth();
        this.cc_expiry_year = editor.getCCExpiryYear();
        this.cc_start_month = editor.getCCStartMonth();
        this.cc_start_year = editor.getCCStartYear();
        this.cc_issue_number = editor.getCCIssueNumber();
        this.cc_type = editor.getCCType();
        this.cc_security = editor.getCCSecurity();
    }

    public void toCCAddressSetter(CreditCardAddressDetailsSetter setter) {
        setter.setAddress1(this.address1);
        setter.setAddress2(this.address2);
        setter.setAddress3(this.address3);
        setter.setStateOrCounty(this.stateOrCounty);
        setter.setPostCode(this.postCode);
        setter.setCountry(this.country);
    }

    public void fromCCAddressGetter(CreditCardAddressDetailsGetter getter) {
        this.address1 = getter.getAddress1();
        this.address2 = getter.getAddress2();
        this.address3 = getter.getAddress3();
        this.stateOrCounty = getter.getStateOrCounty();
        this.postCode = getter.getPostCode();
        this.country = getter.getCountry();
    }

    public RegistrationDetails createRegistration() {
        return new RegistrationDetails(this.gameTitle, this.delivery_name, this.addressAsOneLine(), this.email);
    }

    public SealedObject seal(SecretKey[] retKey) throws Exception {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.addProvider((Provider)provider);
        KeyGenerator keygen = KeyGenerator.getInstance("DES", (Provider)provider);
        retKey[0] = keygen.generateKey();
        Cipher cipher = Cipher.getInstance("DES", (Provider)provider);
        cipher.init(1, retKey[0]);
        return new SealedObject(this, cipher);
    }

    private String addressAsOneLine() {
        StringBuffer ret = new StringBuffer(128);
        if (this.address1 != null && this.address1.trim().length() > 0) {
            ret.append(this.address1);
        }
        if (this.address2 != null && this.address2.trim().length() > 0) {
            if (ret.length() != 0) {
                ret.append(' ');
            }
            ret.append(this.address2);
        }
        if (this.address3 != null && this.address3.trim().length() > 0) {
            if (ret.length() != 0) {
                ret.append(' ');
            }
            ret.append(this.address3);
        }
        if (this.stateOrCounty != null && this.stateOrCounty.trim().length() > 0) {
            if (ret.length() != 0) {
                ret.append(' ');
            }
            ret.append(this.stateOrCounty);
        }
        if (this.postCode != null && this.postCode.trim().length() > 0) {
            if (ret.length() != 0) {
                ret.append(' ');
            }
            ret.append(this.postCode);
        }
        if (this.country != null && this.country.trim().length() > 0) {
            if (ret.length() != 0) {
                ret.append(' ');
            }
            ret.append(this.country);
        }
        return ret.toString();
    }

    public String getCurrency() {
        return Countries.getCurrency(this.country);
    }

    public String getEmail() {
        return this.email;
    }

    public String getAffiliate() {
        return this.affiliate;
    }

    public ConfigurationDetails getConfiguration() {
        return this.configuration;
    }

    public String getGameTitle() {
        return this.gameTitle;
    }

    public String getVersion() {
        return this.version;
    }

    public long getInstallation() {
        return this.installation;
    }

    public static interface CreditCardAddressDetailsGetter {
        public String getAddress1();

        public String getAddress2();

        public String getAddress3();

        public String getStateOrCounty();

        public String getPostCode();

        public String getCountry();
    }

    public static interface CreditCardAddressDetailsSetter {
        public void setAddress1(String var1);

        public void setAddress2(String var1);

        public void setAddress3(String var1);

        public void setStateOrCounty(String var1);

        public void setPostCode(String var1);

        public void setCountry(String var1);
    }

    public static interface CreditCardAddressDetailsEditor
    extends CreditCardAddressDetailsGetter,
    CreditCardAddressDetailsSetter {
    }

    public static interface CreditCardDetailsGetter {
        public String getCCName();

        public int getCCExpiryMonth();

        public int getCCExpiryYear();

        public int getCCStartMonth();

        public int getCCStartYear();

        public CreditCard getCCType();

        public int getCCIssueNumber();

        public String getCCNumber();

        public String getCCSecurity();
    }

    public static interface CreditCardDetailsSetter {
        public void setCCName(String var1);

        public void setCCNumber(String var1);

        public void setCCExpiryMonth(int var1);

        public void setCCExpiryYear(int var1);

        public void setCCStartMonth(int var1);

        public void setCCStartYear(int var1);

        public void setCCType(CreditCard var1);

        public void setCCIssueNumber(int var1);

        public void setCCSecurity(String var1);
    }

    public static interface CreditCardDetailsEditor
    extends CreditCardDetailsGetter,
    CreditCardDetailsSetter {
    }

    public static interface UserDetailsGetter {
        public String getEmail();

        public char[] getPassword();

        public String getPhone();

        public String getDeliveryName();
    }

    public static interface UserDetailsSetter {
        public void setEmail(String var1);

        public void setPassword(char[] var1);

        public void setPhone(String var1);

        public void setDeliveryName(String var1);
    }

    public static interface UserDetailsEditor
    extends UserDetailsGetter,
    UserDetailsSetter {
    }
}

