/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.util.Util;
import invaders.EnemyBullet;
import invaders.EnemyBulletFeature;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.ShootBrain;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ShootBrainFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private Range range;
    private String bullet;
    private transient EnemyBulletFeature bulletFeature;

    public ShootBrainFeature() {
    }

    public ShootBrainFeature(String name) {
        super(name);
    }

    public ShootBrain spawn(Gidrah gidrah) {
        return new ShootBrainInstance(gidrah, this);
    }

    private static class ShootBrainInstance
    implements ShootBrain {
        private static final long serialVersionUID = 1L;
        private final Gidrah gidrah;
        private int tick;
        private transient ShootBrainFeature feature;

        ShootBrainInstance(Gidrah gidrah, ShootBrainFeature feature) {
            this.gidrah = gidrah;
            this.feature = feature;
            this.initTick();
            this.tick /= 2;
        }

        private void initTick() {
            if (this.feature.bulletFeature.isNotDifficultyAdjusted()) {
                this.tick = (int)this.feature.range.getValue();
            } else {
                int minMax = (int)this.feature.range.getMin() * 2;
                this.tick = Math.max((int)this.feature.range.getMin(), Util.random((int)((int)this.feature.range.getMin()), (int)Math.max(minMax, (int)this.feature.range.getMax() - Invaders.getGameState().getTotalMultiplier() / 2)));
                int numGidrahs = Gidrah.getGidrahs().size();
                if (numGidrahs == 1) {
                    this.tick = (int)((float)this.tick * 0.125f);
                } else if (numGidrahs <= 4) {
                    this.tick = (int)((float)this.tick * 0.25f);
                } else if (numGidrahs <= Invaders.getGameState().getMultiplier()) {
                    this.tick = (int)((float)this.tick * 0.5f);
                }
            }
        }

        public void tick() {
            if (--this.tick <= 0) {
                this.fire();
            }
        }

        private void fire() {
            this.initTick();
            EnemyBullet b = this.feature.bulletFeature.spawn(GameScreen.getInstance());
            b.setLocation(this.gidrah.getX(), this.gidrah.getY());
            if (this.feature.bulletFeature.isCurveBall()) {
                b.setVX(this.gidrah.getBehaviourInstance().getVX());
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            if (this.feature.getName() != null) {
                stream.writeBoolean(true);
                stream.writeUTF(this.feature.getName());
            } else {
                stream.writeBoolean(false);
                stream.writeObject((Object)this.feature);
            }
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                boolean namedFeature = stream.readBoolean();
                if (namedFeature) {
                    this.feature = (ShootBrainFeature)Resources.get((String)stream.readUTF());
                } else {
                    this.feature = (ShootBrainFeature)((Object)stream.readObject());
                    this.feature.create();
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

