/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.util.Util;
import invaders.Bullet;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.InvadersGameState;
import invaders.Laser;
import invaders.Powerup;
import invaders.Res;
import invaders.Smartbomb;
import invaders.powerups.InvulnerabilityPowerupFeature;
import invaders.powerups.MoneyPowerupFeature;
import invaders.powerups.ScorePowerupFeature;
import invaders.powerups.ShieldPowerupFeature;
import invaders.powerups.SmartbombPowerupFeature;
import invaders.powerups.SuperGunPowerupFeature;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.Color;

public class Saucer
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final float CHALLENGE_SPEED = 2.0f;
    private static final float CHALLENGE_MULTIPLIER = 0.001f;
    private static final float MULTIPLIER = 0.005f;
    private static final float MIN_SPEED = 0.5f;
    private static final float MAX_SPEED = 2.0f;
    private static final float Y_POS = 280.0f;
    private static int spawned;
    private static int shot;
    private static int removed;
    private static int numSaucers;
    private float dx;
    private transient SoundEffect soundEffect;
    private int tick;
    private boolean challenge;
    private boolean bounced;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("invaders.Saucer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        spawned = 0;
        shot = 0;
        removed = 0;
    }

    public static void resetChallenge() {
        spawned = 0;
        shot = 0;
        removed = 0;
    }

    public static int getNumberShot() {
        return shot;
    }

    public static int getNumberSpawned() {
        return spawned;
    }

    public static int getNumberRemoved() {
        return removed;
    }

    public static void reinit(int spawned, int shot, int removed) {
        Saucer.spawned = spawned;
        Saucer.shot = shot;
        Saucer.removed = removed;
    }

    public void setChallenge(boolean challenge) {
        this.challenge = challenge;
    }

    protected void doSpawn() {
        float y;
        float x;
        this.dx = this.challenge ? 2.0f + (float)Invaders.getGameState().getTotalMultiplier() * 0.001f : Math.min(2.0f, Math.max(0.5f, 0.005f * (float)Invaders.getGameState().getTotalMultiplier()));
        if (Math.random() < 0.5) {
            this.dx = -this.dx;
            x = (float)Invaders.getWidth() + this.getRadius() * 2.0f;
        } else {
            x = -this.getRadius() * 2.0f;
        }
        if (this.challenge) {
            ++spawned;
            y = Util.random((int)83, (int)(Game.getHeight() - 80));
            float ratio = (y - 83.0f) / ((float)(Game.getHeight() - 80) - 83.0f);
            this.dx = (float)((double)this.dx * ((double)LinearInterpolator.instance.interpolate(1.0f, 0.2f, ratio) + Math.random() / 3.0));
            this.setAppearance((AnimatedAppearance)Res.getChallengeSaucer());
        } else {
            ++numSaucers;
            y = 280.0f;
            this.setAppearance(GameScreen.getSaucerAppearance());
        }
        this.setLocation(x, y);
        this.soundEffect = Invaders.allocateSound((ALBuffer)Res.getSaucerSound());
    }

    protected void doRespawn() {
        this.soundEffect = Invaders.allocateSound((ALBuffer)Res.getSaucerSound());
        if (!this.challenge) {
            ++numSaucers;
        }
    }

    public boolean canCollide() {
        return true;
    }

    public boolean canCollideWithLaser() {
        return true;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithSaucer(this);
    }

    public void onCollisionWithBullet(Bullet bullet) {
        if (this.challenge) {
            ++shot;
        }
        this.kill(!this.challenge);
    }

    private void kill(boolean award) {
        block18: {
            Powerup p;
            block21: {
                block23: {
                    block19: {
                        block22: {
                            block20: {
                                if (award) {
                                    InvadersGameState gameState = Invaders.getGameState();
                                    int mult = gameState.getMultiplier();
                                    int pts = gameState.getSaucerValue();
                                    gameState.nextSaucerValue();
                                    gameState.addScore(pts * mult);
                                    LabelEffect effect = new LabelEffect(Res.getSmallFont(), String.valueOf(String.valueOf(pts)) + (mult > 1 ? "x" + mult : ""), Color.WHITE, Color.RED, 90, 30);
                                    effect.spawn((Screen)GameScreen.getInstance());
                                    effect.setLocation((float)((int)this.getX()), (float)((int)this.getY()));
                                }
                                Emitter e = this.challenge ? Res.getChallengeSaucerExplosionEmitter().spawn((Screen)GameScreen.getInstance()) : Res.getSaucerExplosionEmitter().spawn((Screen)GameScreen.getInstance());
                                e.setLocation(this.getX(), this.getY());
                                if (this.challenge) break block18;
                                if (Invaders.getGameState().getShields() != 0) break block19;
                                if (Gidrah.getGidrahs().size() <= 8) break block20;
                                p = SmartbombPowerupFeature.getInstance().createInstance();
                                break block21;
                            }
                            if (Gidrah.getGidrahs().size() >= 6) break block22;
                            p = ShieldPowerupFeature.getInstance().createInstance();
                            break block21;
                        }
                        switch (Util.random((int)0, (int)3)) {
                            case 0: {
                                p = ShieldPowerupFeature.getInstance().createInstance();
                                break block21;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                p = InvulnerabilityPowerupFeature.getInstance().createInstance();
                                break block21;
                            }
                            default: {
                                p = null;
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break block21;
                            }
                        }
                    }
                    if (Gidrah.getGidrahs().size() <= 4) break block23;
                    switch (Util.random((int)0, (int)7)) {
                        case 0: {
                            p = SuperGunPowerupFeature.getInstance().createInstance();
                            break block21;
                        }
                        case 1: {
                            p = InvulnerabilityPowerupFeature.getInstance().createInstance();
                            break block21;
                        }
                        case 2: 
                        case 3: {
                            p = MoneyPowerupFeature.getInstance().createInstance();
                            break block21;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            p = ScorePowerupFeature.getInstance().createInstance();
                            break block21;
                        }
                        default: {
                            p = null;
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break block21;
                        }
                    }
                }
                switch (Util.random((int)0, (int)3)) {
                    case 0: {
                        p = MoneyPowerupFeature.getInstance().createInstance();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        p = ScorePowerupFeature.getInstance().createInstance();
                        break;
                    }
                    default: {
                        p = null;
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            p.spawn(GameScreen.getInstance());
            p.setLocation(this.getX(), this.getY());
        }
        this.remove();
    }

    public void onCollisionWithSmartbomb(Smartbomb smartBomb) {
        if (this.challenge) {
            ++shot;
        }
        this.kill(!this.challenge);
    }

    public void onCollisionWithLaser(Laser laser) {
        if (this.challenge) {
            ++shot;
        }
        this.kill(!this.challenge);
    }

    public float getRadius() {
        return this.challenge ? 10.0f : 8.0f;
    }

    protected void doTick() {
        this.setLocation(this.getX() + this.dx, this.getY());
        if (this.challenge) {
            ++this.tick;
            if (!this.bounced && this.tick > 90 && Math.random() < 0.0025) {
                if (this.dx < 0.0f && this.getX() > (float)Game.getWidth() * 0.7f) {
                    return;
                }
                if (this.dx > 0.0f && this.getX() < (float)Game.getWidth() * 0.3f) {
                    return;
                }
                this.bounced = true;
                this.dx *= -0.75f;
                this.tick = 0;
            }
        }
    }

    protected void doRemove() {
        if (this.soundEffect != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.soundEffect.stop((Object)clazz);
            this.soundEffect = null;
        }
        if (this.challenge) {
            ++removed;
            this.challenge = false;
        } else {
            --numSaucers;
        }
    }

    public static int numSaucers() {
        return numSaucers;
    }

    public boolean isChallenge() {
        return this.challenge;
    }
}

