/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.util.Util;
import invaders.Behaviour;
import invaders.EnemyBullet;
import invaders.EnemyBulletFeature;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.Level;
import invaders.Parachute;
import invaders.Player;
import invaders.PowerupFeature;
import invaders.Res;
import invaders.SFX;
import invaders.Saucer;
import invaders.ShopPrices;
import invaders.ShopScreen;
import invaders.behaviours.Centipede;
import invaders.behaviours.Galaxian;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameState;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.Color;

public class InvadersGameState
extends GameState {
    private static final long serialVersionUID = 2L;
    private static final int DEFAULT_SHIELDS = 3;
    private static final int MAX_SHIELDS = 8;
    private static final int MAX_SMARTS = 3;
    private static final int MAX_MULTIPLIER = 9;
    private static final float MULTIPLIER_FACTOR = 0.5f;
    private static final int DIFFICULTY_CAP = 50;
    private static final int MAX_SMARTBOMB_PRICE = 9900;
    private static final int SAVE_DURATION = 45;
    private static final int END_OF_LEVEL_DURATION = 180;
    private static final int WAIT_FOR_BOSS_DURATION = 240;
    private static final int BOSS_DEFEATED_DURATION = 360;
    private static final int CHALLENGE_BEGIN_DURATION = 360;
    private static final int CHALLENGE_DURATION = 800;
    private static final int CHALLENGE_DURATION_PER_LEVEL = 10;
    private static final int MAX_CHALLENGE_DURATION = 1000;
    private static final int CHALLENGE_SPAWN_RATE = 70;
    private static final int MIN_CHALLENGE_SPAWN_RATE = 15;
    private static final float CHALLENGE_SPAWN_RATE_PER_LEVEL = 0.33f;
    private static final int CHALLENGE_END_DURATION = 480;
    private static final int END_OF_GAME_DURATION = 480;
    private static final int SAUCER_KILLS = 10;
    private static final int INITIAL_SAUCER_VALUE = 100;
    private static final int SAUCER_VALUE_INCREMENT = 100;
    private transient int saveTick;
    private transient boolean saving;
    private int shields = 3;
    private int gunPower = 0;
    private int gunReloadRate = 0;
    private int extraBullets = 0;
    private int shipSpeed = 0;
    private int smartBombs = 0;
    private int smartBombPrice = 500;
    private int addOn = 0;
    private int score = 0;
    private int money = 0;
    private int level = -1;
    private transient Level currentLevel;
    private int multiplier;
    private int totalMultiplier = (this.level + 1) * 4;
    private boolean damaged;
    private final ArrayList entities = new ArrayList();
    private int tick;
    private int totalTicks;
    private Player player;
    private int meteorTick;
    private int saucerKills = 0;
    private int saucerValue = 100;
    private int phase;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_END_OF_LEVEL = 1;
    private static final int PHASE_CHALLENGE_BEGIN = 2;
    private static final int PHASE_CHALLENGE = 3;
    private static final int PHASE_CHALLENGE_END = 4;
    private static final int PHASE_WAIT_FOR_BOSS = 5;
    private static final int PHASE_BOSS = 6;
    private static final int PHASE_BOSS_DEFEATED = 7;
    private static final int PHASE_END_OF_GAME = 8;
    private static final String[] BOSS_MESSAGES;
    private static final String[] PLANET_NAMES;
    private static final String[] NEXT_PLANET;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("invaders.InvadersGameState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        BOSS_MESSAGES = new String[]{"SAVE THE EARTH!", "SAVE THE MOON!", "SAVE MARS!", "DEFEAT THE GUARDIAN!", "DESTROY THE ALIEN BRAIN!"};
        PLANET_NAMES = new String[]{"EARTH SECURED!", "MOON SECURED!", "MARS SECURED!", "SATURN CONQUERED!", "ALIEN INVASION THWARTED!"};
        NEXT_PLANET = new String[]{"On To The Moon!", "On To Mars!", "Now Invade Saturn!", "To the Alien Homeworld!", "YOU ARE A HERO!"};
    }

    public void nextLevel() {
        ++this.level;
        this.currentLevel = Level.getLevel(this.level);
        GameScreen.beginLevel();
        this.totalMultiplier += 10;
        if (!this.damaged) {
            this.incMultiplier();
        }
        this.damaged = false;
        this.entities.clear();
        this.phase = 0;
        this.tick = 0;
        this.entities.clear();
        this.meteorTick = Util.random((int)0, (int)this.currentLevel.getMeteorFrequency());
        Gidrah.getGidrahs().clear();
        Centipede.reset();
        this.player = new Player();
        this.player.spawn(GameScreen.getInstance());
        LabelEffect newLevelEffect = new LabelEffect(Res.getBigFont(), "Wave " + (Invaders.getGameState().getCurrentLevel().getIndex() + 1), Color.WHITE, Color.BLUE, 320, 120);
        newLevelEffect.setLocation((float)(Invaders.getWidth() / 2), (float)Invaders.getHeight() * 0.8f);
        newLevelEffect.setVisible(true);
        newLevelEffect.spawn((Screen)GameScreen.getInstance());
        if (this.multiplier > 1) {
            LabelEffect le = new LabelEffect(Res.getSmallFont(), "Times " + this.multiplier + " Multiplier Active", Color.WHITE, Color.BLUE, 320, 120);
            le.setLocation((float)(Game.getWidth() / 2), (float)Invaders.getHeight() * 0.8f - 20.0f);
            le.setVisible(true);
            le.setDelay(30);
            le.setSound(Res.getMultiplierActiveSound(this.multiplier));
            le.spawn((Screen)GameScreen.getInstance());
        }
        try {
            List gidrahs = this.currentLevel.createGidrahs();
            Iterator i = gidrahs.iterator();
            while (i.hasNext()) {
                Gidrah gidrah = (Gidrah)i.next();
                gidrah.spawn(GameScreen.getInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void damageShields() {
        --this.shields;
        this.damaged = true;
        this.resetMultiplier();
    }

    public void increaseShields() {
        this.shields = Math.min(8, this.shields + 1);
    }

    public void completeLevel() {
        ++this.level;
        ShopScreen.show();
    }

    public int getTotalLevels() {
        return 50;
    }

    public Level getCurrentLevel() {
        return this.currentLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public int getScore() {
        return this.score;
    }

    public int getMoney() {
        return this.money;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void incMultiplier() {
        this.multiplier = Math.min(9, this.multiplier + 1);
    }

    public void resetMultiplier() {
        this.multiplier = 1;
    }

    public void addScore(int pointsDelta) {
        this.score += pointsDelta;
        if (this.score < 0) {
            this.score = 0;
        }
    }

    public void addMoney(int moneyDelta) {
        this.money += moneyDelta;
        if (this.money < 0) {
            this.money = 0;
        }
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public int getAddOn() {
        return this.addOn;
    }

    public int getGunReloadRate() {
        return this.gunReloadRate;
    }

    public int getExtraBullets() {
        return this.extraBullets;
    }

    public int getGunPower() {
        return this.gunPower;
    }

    public int getShields() {
        return this.shields;
    }

    public int getShipSpeed() {
        return this.shipSpeed;
    }

    public float getShipSpeedPerFrame() {
        return (float)this.shipSpeed + 1.0f;
    }

    public int getSmartBombs() {
        return this.smartBombs;
    }

    public void adjustSmartBombs(int delta) {
        this.smartBombs = Math.max(0, Math.min(3, this.smartBombs + delta));
    }

    public void buyGunPower() {
        this.money -= ShopPrices.GUN_POWER[this.gunPower++];
    }

    public void buyExtraBullets() {
        this.money -= ShopPrices.EXTRA_BULLETS[this.extraBullets++];
    }

    public void buyShields() {
        this.money -= ShopPrices.SHIELDS[this.shields++] * (1 + this.level / 100);
    }

    public void buyAddOn() {
        this.money -= ShopPrices.ADDON[this.addOn++];
    }

    public void buySmartBomb() {
        this.money -= this.smartBombPrice;
        this.smartBombPrice = Math.min(9900, this.smartBombPrice + 100);
        this.adjustSmartBombs(1);
    }

    public void buyShipSpeed() {
        this.money -= ShopPrices.SHIP_SPEED[this.shipSpeed++];
    }

    public boolean canBuyGunPower() {
        return this.money >= ShopPrices.GUN_POWER[this.gunPower] && ShopPrices.GUN_POWER[this.gunPower] != -1;
    }

    public boolean canBuyExtraBullets() {
        return this.money >= ShopPrices.EXTRA_BULLETS[this.extraBullets] && ShopPrices.EXTRA_BULLETS[this.extraBullets] != -1;
    }

    public boolean canBuyShields() {
        return this.money >= ShopPrices.SHIELDS[this.shields] && ShopPrices.SHIELDS[this.shields] != -1;
    }

    public boolean canBuySmartBombs() {
        return this.money >= this.smartBombPrice && this.smartBombs < 3;
    }

    public boolean canBuyAddOns() {
        return this.money >= ShopPrices.ADDON[this.addOn] && ShopPrices.ADDON[this.addOn] != -1;
    }

    public boolean canBuyShipSpeed() {
        return this.money >= ShopPrices.SHIP_SPEED[this.shipSpeed] && ShopPrices.SHIP_SPEED[this.shipSpeed] != -1;
    }

    public void cleanup() {
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getTick() {
        return this.tick;
    }

    public int getTotalTicks() {
        return this.totalTicks;
    }

    public void resetTotalTicks() {
        this.totalTicks = 0;
    }

    private void tickAllEntities() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity src = (Entity)this.entities.get(i);
            if (!src.isActive()) {
                this.entities.remove(i);
                continue;
            }
            int j = i + 1;
            while (j < this.entities.size() && src.isActive()) {
                Entity dest = (Entity)this.entities.get(j);
                if (!dest.isActive()) {
                    this.entities.remove(j);
                    continue;
                }
                if (src.canCollide() && dest.canCollide() && src.isTouching(dest)) {
                    src.onCollision(dest);
                    dest.onCollision(src);
                    if (!src.isActive()) {
                        this.entities.remove(i--);
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void tickNormal() {
        Galaxian.tickGalaxians();
        this.doSaucers();
        this.doMeteors();
        if (Gidrah.getGidrahs().size() == 0 && Parachute.getNumParachutes() == 0 && Saucer.numSaucers() == 0 && PowerupFeature.numPowerups() == 0 && this.player.isAlive()) {
            this.tick = 0;
            if (this.level % 20 == 19) {
                this.phase = 5;
                LabelEffect challengeEffect = new LabelEffect(Res.getBigFont(), "THE ALIEN MOTHERSHIP", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 40));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.getInstance());
                LabelEffect challengeEffect2 = new LabelEffect(Res.getSmallFont(), "Fight To The Death!!!", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect2.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2));
                challengeEffect2.setVisible(true);
                challengeEffect2.spawn((Screen)GameScreen.getInstance());
                challengeEffect2.setDelay(120);
            } else if (this.level % 7 == 6) {
                this.phase = 2;
                LabelEffect challengeEffect = new LabelEffect(Res.getBigFont(), "CHALLENGE STAGE", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 40));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.getInstance());
                LabelEffect challengeEffect2 = new LabelEffect(Res.getSmallFont(), "Shoot all saucers", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect2.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2));
                challengeEffect2.setVisible(true);
                challengeEffect2.spawn((Screen)GameScreen.getInstance());
                challengeEffect2.setDelay(120);
                LabelEffect challengeEffect3 = new LabelEffect(Res.getSmallFont(), "Perfection wins prizes", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect3.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 - 20));
                challengeEffect3.setVisible(true);
                challengeEffect3.spawn((Screen)GameScreen.getInstance());
                challengeEffect3.setDelay(240);
            } else {
                this.phase = 1;
                LabelEffect challengeEffect = new LabelEffect(Res.getBigFont(), "Wave Completed", Color.WHITE, Color.BLUE, 60, 240);
                challengeEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.getInstance());
                SFX.waveCompleted();
            }
        }
    }

    private void tickEndOfLevel() {
        if (this.tick >= 180) {
            if (this.player.isAlive()) {
                ShopScreen.show();
            } else {
                Game.gameOver();
            }
        }
    }

    private void tickChallengeBegin() {
        if (this.tick >= 360) {
            this.phase = 3;
            this.tick = 0;
            Saucer.resetChallenge();
        }
    }

    private void tickChallenge() {
        String prize;
        int bonus;
        block31: {
            block32: {
                int ratio;
                block30: {
                    if (this.tick < Math.min(1000, 800 + 10 * this.level)) {
                        if (this.tick % (int)Math.max(15.0f, 70.0f - 0.33f * (float)this.level) == 0) {
                            Saucer saucer = new Saucer();
                            saucer.setChallenge(true);
                            saucer.spawn(GameScreen.getInstance());
                        }
                        return;
                    }
                    if (Saucer.getNumberRemoved() < Saucer.getNumberSpawned()) {
                        return;
                    }
                    this.phase = 4;
                    this.tick = 0;
                    LabelEffect bonusEffect = new LabelEffect(Res.getBigFont(), "CHALLENGE COMPLETE", Color.YELLOW, Color.RED, 60, 240);
                    bonusEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 40));
                    bonusEffect.setVisible(true);
                    bonusEffect.setSound(Res.getChallengeComplete());
                    bonusEffect.spawn((Screen)GameScreen.getInstance());
                    ratio = 100 * Saucer.getNumberShot() / Saucer.getNumberSpawned();
                    String message = ratio == 100 ? "PERFECT!" : "Shot " + Saucer.getNumberShot() + " / " + Saucer.getNumberSpawned() + " : " + ratio + "%";
                    LabelEffect bonusEffect2 = new LabelEffect(Res.getSmallFont(), message, Color.YELLOW, Color.RED, 60, 240);
                    bonusEffect2.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2));
                    bonusEffect2.setVisible(true);
                    bonusEffect2.setDelay(120);
                    bonusEffect2.setSound(ratio == 100 ? Res.getChallengePerfect() : Res.getChallengeBonus1());
                    bonusEffect2.spawn((Screen)GameScreen.getInstance());
                    int rate = 50 * (1 + this.getLevel() / 7);
                    bonus = ratio * rate;
                    LabelEffect bonusEffect3 = new LabelEffect(Res.getSmallFont(), "Bonus " + ratio + "% x " + rate + " = " + bonus + " points", Color.YELLOW, Color.RED, 60, 240);
                    bonusEffect3.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 - 20));
                    this.addScore(bonus);
                    bonusEffect3.setVisible(true);
                    bonusEffect3.setDelay(240);
                    bonusEffect3.setSound(Res.getChallengeBonus2());
                    bonusEffect3.spawn((Screen)GameScreen.getInstance());
                    if (ratio != 100) break block30;
                    switch (Util.random((int)0, (int)4)) {
                        case 0: {
                            this.addMoney(1000);
                            prize = "$1000";
                            break block31;
                        }
                        case 1: {
                            if (this.shields >= ShopPrices.SHIELDS.length - 2) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                this.shields += 2;
                                prize = "2 Extra Shields";
                            }
                            break block31;
                        }
                        case 2: {
                            if (this.extraBullets >= ShopPrices.EXTRA_BULLETS.length - 1) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                ++this.extraBullets;
                                prize = "Weapons Boost";
                            }
                            break block31;
                        }
                        case 3: {
                            if (this.gunPower >= ShopPrices.GUN_POWER.length - 1) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                ++this.gunPower;
                                prize = "Weapons Boost";
                            }
                            break block31;
                        }
                        case 4: {
                            if (this.smartBombs == 3) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                ++this.smartBombs;
                                prize = "Extra Smartbomb";
                            }
                            break block31;
                        }
                        default: {
                            prize = "Nothing";
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break block31;
                        }
                    }
                }
                if (ratio < 75) break block32;
                switch (Util.random((int)0, (int)2)) {
                    case 0: {
                        this.addMoney(500);
                        prize = "$500";
                        break block31;
                    }
                    case 1: {
                        if (this.shields >= ShopPrices.SHIELDS.length - 1) {
                            this.addMoney(500);
                            prize = "$500";
                        } else {
                            ++this.shields;
                            prize = "Extra Shield";
                        }
                        break block31;
                    }
                    case 2: {
                        if (this.smartBombs == 3) {
                            this.addMoney(500);
                            prize = "$500";
                        } else {
                            ++this.smartBombs;
                            prize = "Extra Smartbomb";
                        }
                        break block31;
                    }
                    default: {
                        prize = "Nothing";
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break block31;
                    }
                }
            }
            prize = "No Prizes";
        }
        if (prize != null) {
            LabelEffect bonusEffect4 = new LabelEffect(Res.getSmallFont(), prize, Color.YELLOW, Color.RED, 60, 240);
            bonusEffect4.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 - 40));
            this.addScore(bonus);
            bonusEffect4.setVisible(true);
            bonusEffect4.setDelay(360);
            bonusEffect4.setSound(Res.getChallengeBonus2());
            bonusEffect4.spawn((Screen)GameScreen.getInstance());
        }
    }

    private void tickChallengeEnd() {
        if (this.tick >= 480) {
            ShopScreen.show();
        }
    }

    private void tickEndOfGame() {
        if (this.money >= 10) {
            this.addMoney(-10);
            this.addScore(100);
            SFX.keyTyped();
        }
        if (this.tick >= 480 && this.money < 10) {
            Game.gameOver();
        }
    }

    private void tickWaitForBoss() {
        if (this.tick >= 240) {
            Behaviour boss = this.currentLevel.getBoss();
            Gidrah g = new Gidrah(boss, 0);
            g.spawn(GameScreen.getInstance());
            this.phase = 6;
            this.tick = 0;
        }
    }

    private void expireDemo() {
        this.player.kill();
        LabelEffect nagEffect = new LabelEffect(Res.getBigFont(), "): ): DEMO EXPIRED :( :(", Color.YELLOW, Color.RED, 160, 240);
        nagEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 32));
        nagEffect.setVisible(true);
        nagEffect.spawn((Screen)GameScreen.getInstance());
        Game.getPreferences().putBoolean("showregister", true);
        this.phase = 8;
        this.tick = 0;
    }

    private void tickBoss() {
        if (!Game.isRegistered() && this.level >= 39) {
            ++this.tick;
            if (this.tick == 450) {
                this.expireDemo();
                return;
            }
        } else if (Gidrah.getGidrahs().size() == 0 && this.player.isAlive()) {
            LabelEffect challengeEffect = new LabelEffect(Res.getBigFont(), "WELL DONE COMMANDER!", Color.YELLOW, Color.RED, 60, 240);
            challengeEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 40));
            challengeEffect.setVisible(true);
            challengeEffect.spawn((Screen)GameScreen.getInstance());
            LabelEffect challengeEffect2 = new LabelEffect(Res.getSmallFont(), PLANET_NAMES[this.level % 100 / 20], Color.YELLOW, Color.RED, 60, 240);
            challengeEffect2.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2));
            challengeEffect2.setVisible(true);
            challengeEffect2.spawn((Screen)GameScreen.getInstance());
            challengeEffect2.setDelay(120);
            LabelEffect challengeEffect3 = new LabelEffect(Res.getSmallFont(), NEXT_PLANET[this.level % 100 / 20], Color.YELLOW, Color.RED, 60, 240);
            challengeEffect3.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 - 20));
            challengeEffect3.setVisible(true);
            challengeEffect3.spawn((Screen)GameScreen.getInstance());
            challengeEffect3.setDelay(240);
            if (this.level % 100 == 99) {
                LabelEffect challengeEffect4 = new LabelEffect(Res.getBigFont(), "DOUBLE POINTS!", Color.WHITE, Color.RED, 60, 240);
                challengeEffect4.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 - 45));
                challengeEffect4.setVisible(true);
                challengeEffect4.spawn((Screen)GameScreen.getInstance());
                challengeEffect4.setDelay(360);
                this.addScore(this.score);
                this.tick = -300;
            } else {
                this.tick = 0;
            }
            this.phase = 7;
            SFX.wellDoneCommander();
        }
    }

    private void tickBossDefeated() {
        if (this.tick >= 360) {
            if (this.player.isAlive()) {
                ShopScreen.show();
            } else {
                Game.gameOver();
            }
        }
    }

    void tick() {
        if (Keyboard.isKeyDown((int)1) && this.player.canCollide() && !this.saving) {
            this.saving = true;
            this.saveTick = 0;
            LabelEffect saveEffect = new LabelEffect(Res.getBigFont(), "SAVING GAME...", Color.WHITE, Color.BLUE, 22, 22);
            saveEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 32));
            saveEffect.setVisible(true);
            saveEffect.spawn((Screen)GameScreen.getInstance());
        }
        if (this.saving && this.player.canCollide()) {
            ++this.saveTick;
            if (this.saveTick >= 45) {
                Game.saveGame();
                return;
            }
        }
        ++this.tick;
        ++this.totalTicks;
        this.doPhase();
        this.tickAllEntities();
    }

    private void doPhase() {
        switch (this.phase) {
            case 0: {
                this.tickNormal();
                break;
            }
            case 1: {
                this.tickEndOfLevel();
                break;
            }
            case 2: {
                this.tickChallengeBegin();
                break;
            }
            case 3: {
                this.tickChallenge();
                break;
            }
            case 4: {
                this.tickChallengeEnd();
                break;
            }
            case 5: {
                this.tickWaitForBoss();
                break;
            }
            case 6: {
                this.tickBoss();
                break;
            }
            case 7: {
                this.tickBossDefeated();
                break;
            }
            case 8: {
                this.tickEndOfGame();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private void doSaucers() {
        if (this.saucerKills > 10 + this.level / 3) {
            this.saucerKills = 0;
            Saucer saucer = new Saucer();
            saucer.spawn(GameScreen.getInstance());
        }
    }

    public void bumpSaucer() {
        ++this.saucerKills;
    }

    private void doMeteors() {
        if (this.currentLevel.getMeteorFrequency() > 0) {
            --this.meteorTick;
            if (this.meteorTick <= 0) {
                EnemyBulletFeature f;
                this.meteorTick = Util.random((int)0, (int)this.currentLevel.getMeteorFrequency());
                switch (Util.random((int)0, (int)2)) {
                    case 0: {
                        f = Res.getLargeMeteor();
                        break;
                    }
                    case 1: {
                        f = Res.getMediumMeteor();
                        break;
                    }
                    default: {
                        f = Res.getSmallMeteor();
                    }
                }
                EnemyBullet meteor = f.spawn(GameScreen.getInstance());
                if (meteor != null) {
                    float x = Util.random((int)0, (int)Game.getWidth());
                    meteor.setLocation(x, (float)Game.getHeight() + meteor.getRadius());
                    float vx = x < (float)(Game.getWidth() / 2) ? 0.5f : -0.5f;
                    meteor.setVelocity(vx, (float)Util.random((int)0, (int)5) * 0.5f);
                }
            }
        }
    }

    public void init() {
        GameScreen.beginGame(this);
        this.nextLevel();
        this.doInitMessages("SAVE THE HUMAN RACE!", "Hit ESC to save game and quit");
    }

    private void doInitMessages(String big, String small) {
        LabelEffect newLevelEffect = new LabelEffect(Res.getBigFont(), big, Color.WHITE, Color.RED, 40, 160);
        newLevelEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 60));
        newLevelEffect.setVisible(true);
        newLevelEffect.spawn((Screen)GameScreen.getInstance());
        LabelEffect hintEffect = new LabelEffect(Res.getSmallFont(), small, Color.WHITE, Color.RED, 40, 160);
        hintEffect.setDelay(30);
        hintEffect.setLocation((float)(Game.getWidth() / 2), (float)(Game.getHeight() / 2 + 20));
        hintEffect.setVisible(true);
        hintEffect.spawn((Screen)GameScreen.getInstance());
    }

    public void reinit() {
        GameScreen.beginGame(this);
        this.currentLevel = Level.getLevel(this.level);
        this.doInitMessages("RESUMING GAME", "Hit ESC to save game and quit");
        Iterator i = this.entities.iterator();
        while (i.hasNext()) {
            Entity entity = (Entity)i.next();
            entity.respawn(GameScreen.getInstance());
        }
        GameScreen.beginLevel();
        if (this.player == null || !this.player.isActive()) {
            Game.endGame();
        }
    }

    public ArrayList getEntities() {
        return this.entities;
    }

    public int getSaucerValue() {
        return this.saucerValue;
    }

    public void nextSaucerValue() {
        this.saucerValue += 100;
    }

    public int getTotalMultiplier() {
        return this.totalMultiplier;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(Saucer.getNumberSpawned());
        stream.writeInt(Saucer.getNumberShot());
        stream.writeInt(Saucer.getNumberRemoved());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int saucersSpawned = stream.readInt();
        int saucersShot = stream.readInt();
        int saucersRemoved = stream.readInt();
        Saucer.reinit(saucersSpawned, saucersShot, saucersRemoved);
    }

    public int getSmartBombPrice() {
        return this.smartBombPrice;
    }
}

