/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.PluginClassLoader;
import net.java.games.util.plugins.Plugins;

class DefaultControllerEnvironment
extends ControllerEnvironment {
    static final boolean DEBUG = false;
    private static final String PROPERTY_FILENAME = "controller.properties";
    private static final String ID_PLUGIN = "ControllerEnvironment";
    static String libPath;
    private ArrayList controllers;
    private Properties properties = new Properties();
    private PluginClassLoader pluginLoader = new PluginClassLoader();
    private Collection loadedPlugins = new ArrayList();

    public Controller[] getControllers() {
        if (this.controllers == null) {
            this.controllers = new ArrayList();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DefaultControllerEnvironment.this.scanControllers();
                    return DefaultControllerEnvironment.this;
                }
            });
            String pluginClasses = System.getProperty("jinput.plugins", "") + " " + System.getProperty("net.java.games.input.plugins", "");
            if (!System.getProperty("jinput.useDefaultPlugin", "true").toLowerCase().trim().equals("false") && !System.getProperty("net.java.games.input.useDefaultPlugin", "true").toLowerCase().trim().equals("false")) {
                String osName = System.getProperty("os.name", "").trim();
                if (osName.equals("Linux")) {
                    pluginClasses = pluginClasses + " net.java.games.input.LinuxEnvironmentPlugin";
                } else if (osName.equals("Mac OS X")) {
                    pluginClasses = pluginClasses + " net.java.games.input.OSXEnvironmentPlugin";
                } else if (osName.equals("Windows 98") || osName.equals("Windows 2000") || osName.equals("Windows XP")) {
                    pluginClasses = pluginClasses + " net.java.games.input.DirectInputEnvironmentPlugin";
                } else if (osName.startsWith("Windows")) {
                    System.out.println("WARNING: Found unknown Windows version: " + osName);
                    System.out.println("Attempting to use default windows plug-in.");
                    System.out.flush();
                    pluginClasses = pluginClasses + " net.java.games.input.DirectInputEnvironmentPlugin";
                } else {
                    System.out.println("Trying to use default plugin, OS name " + osName + " not recognised");
                }
            }
            ArrayList pluginClassList = new ArrayList();
            StringTokenizer pluginClassTok = new StringTokenizer(pluginClasses, " \t\n\r\f,;:");
            while (pluginClassTok.hasMoreTokens()) {
                String className = pluginClassTok.nextToken();
                try {
                    if (this.loadedPlugins.contains(className)) continue;
                    Class<?> ceClass = Class.forName(className);
                    ControllerEnvironment ce = (ControllerEnvironment)ceClass.newInstance();
                    this.addControllers(ce.getControllers());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        Controller[] ret = new Controller[this.controllers.size()];
        Iterator it = this.controllers.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = (Controller)it.next();
            ++i;
        }
        return ret;
    }

    private void scanControllers() {
        String pluginPathName = System.getProperty("jinput.controllerPluginPath");
        if (pluginPathName == null) {
            pluginPathName = "controller";
        }
        this.scanControllersAt(System.getProperty("java.home") + File.separator + "lib" + File.separator + pluginPathName);
        this.scanControllersAt(System.getProperty("user.dir") + File.separator + pluginPathName);
    }

    private void scanControllersAt(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try {
            Plugins plugins = new Plugins(file);
            Class[] envClasses = plugins.getExtends(ControllerEnvironment.class);
            for (int i = 0; i < envClasses.length; ++i) {
                try {
                    ControllerEnvironment ce = (ControllerEnvironment)envClasses[i].newInstance();
                    this.addControllers(ce.getControllers());
                    this.loadedPlugins.add(ce.getClass().getName());
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadProperties() throws IOException {
        if (libPath == null) {
            libPath = System.getProperty("java.home") + File.separator + "lib";
        }
        File file = new File(libPath + File.separator + PROPERTY_FILENAME);
        FileInputStream inputStream = new FileInputStream(file);
        this.properties.load(inputStream);
        inputStream.close();
    }

    private void addControllers(Controller[] c) {
        for (int i = 0; i < c.length; ++i) {
            this.controllers.add(c[i]);
        }
    }
}

